% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_PaleyII.R
\name{cdn_PaleyII}
\alias{cdn_PaleyII}
\title{cdn_PaleyII
Checks Hadamard Matrix can be constructed using Paley II method.}
\usage{
cdn_PaleyII(order)
}
\arguments{
\item{order}{integer}
}
\value{
3 or NULL
}
\description{
cdn_PaleyII
Checks Hadamard Matrix can be constructed using Paley II method.
}
\details{
In Paley II method,  If q=order/2-1 or q=order/4-1 and q is prime number and
q=1 (mod 4) then this function retuns 3 otherwise NULL.
}
\examples{
cdn_PaleyII(24)
#3
cdn_PaleyII(16)
#NULL
}
\references{
Paley, R.E.A.C. (1933). On Orthogonal matrices. J. Combin. Theory, A 57(1), 86-108.
}
\seealso{
\code{\link{PaleyII}} for Paley II construction method.
}
