% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/had_kronecker.R
\name{had_kronecker}
\alias{had_kronecker}
\title{had_kronecker}
\usage{
had_kronecker(n, exponent = NULL)
}
\arguments{
\item{n}{an integer (Expected to be Hadamard Number)}

\item{exponent}{an integer}
}
\value{
Hadamard Matrix of order n, if n is power of 2, otherwise NULL.
}
\description{
had_kronecker performs the construction of an Hadamard matrix by kronecker product.
}
\details{
This function only applicable when n is the power of 2 and multiple of 4.

If n<-2, returns Hadamard matrix of order 2; if n is not Hadamard number, return NULL.

By default exponent=FALSE; when exponent is unknown it is computed.

If exponent is given use the same
}
\examples{
had_kronecker(4)
#      [,1] [,2] [,3] [,4]
#[1,]    1    1    1    1
#[2,]    1   -1    1   -1
#[3,]    1    1   -1   -1
#[4,]    1   -1   -1    1
had_kronecker(8,3)
#     [,1] [,2] [,3] [,4] [,5] [,6] [,7] [,8]
#[1,]    1    1    1    1    1    1    1    1
#[2,]    1   -1    1   -1    1   -1    1   -1
#[3,]    1    1   -1   -1    1    1   -1   -1
#[4,]    1   -1   -1    1    1   -1   -1    1
#[5,]    1    1    1    1   -1   -1   -1   -1
#[6,]    1   -1    1   -1   -1    1   -1    1
#[7,]    1    1   -1   -1   -1   -1    1    1
#[8,]    1   -1   -1    1   -1    1    1   -1
had_kronecker(9)
 # NULL
}
\references{
Hedayat, A. and Wallis, W.D. (1978). Hadamard Matrices and Their Application.Ann. Stat., 6, 1184-1238.

Sylvester, J.J. (1968). Problem 2511. Math. Questions and solutions, 10, 74.
}
