% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdn_sds.R
\name{cdn_sds}
\alias{cdn_sds}
\title{cdn_sds}
\source{
SDS sets are availble from Djokovic (1992a,b,c,d and 1994a,1994b).
}
\usage{
cdn_sds(order)
}
\arguments{
\item{order}{integer}
}
\value{
10 or NULL
}
\description{
Checks Hadamard Matrix can be constructed using available Suplementary Difference Sets.
}
\details{
This function checks whether the Hadamard matrix of given order can be constructed using Suplementary Diffrence sets.
If SDS is available it Returns the value 10 otherwise NULL.

SDS are available for 103,127,151,163,181,191,239,251,463,631 in the internal table.
}
\examples{
cdn_sds(412)
#10
cdn_sds(428)
#NULL


}
\references{
Djokovic, D. Z. (1992a). Skew Hadamard matrices of order 4x37 and 4x39. J. Combin. Theory, A 61, 319-321.

Djokovic, D. Z. (1992b). Construction of some new Hadamard matrices. Bull. Austral. math. Soc., 45, 327-332.

Djokovic, D. Z. (1992c). Ten new Hadamard matrices of skew type. Publ.Electrotechnickog Fak., Ser. Mathematika, Univ. of Belgrade, 3, 47-59.

Djokovic, D. Z. (1992d). Ten Hadamard matrices of order 1852 of Goethals-Seidel type. Europ. J. Combinatorics, 13, 245-248.

Djokovic, D. Z. (1994a). Two Hadamard matrices of order 956 of Goethals-Seidel type. Combinatorica, 14(3), 375-377.

Djokovic, D. Z. (1994b). Five new Hadamard matrices of order skew type. Austral. J. Combinatorics, 10, 259-264.
}
\seealso{
\code{\link{had_SDS}} for SDS construction method.
}
