% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/had_baumert.R
\name{had_baumert}
\alias{had_baumert}
\title{had_baumert}
\source{
The Williamson sequences are available in London (2013) and
\href{http://www.math.ntua.gr/~ckoukouv/}{Christos Koukouvinos}
}
\usage{
had_baumert(n)
}
\arguments{
\item{n}{integer (order of the matrix)}
}
\value{
Hadamard matrix of order n
}
\description{
had_baumert performs the constrution of Hadamard matrix by Baumert-Hall method.
}
\details{
Baumert-Hall arrays extension of the williamson array. For construction of matrix
it requires the Williamson sequences.For different order of the matrix it requries
different williamson sequences.If williamson sequences are not available it Returns NULL.

Williamson sequences are available for length of seq(1,63, 2) except 15, 35, 47, 53, 59 in the internal table.
}
\examples{
\donttest{
had_baumert(372)
}
#Big matrix.
had_baumert(24)
#NULL
}
\references{
Baumert, L. D., and Hall, M. Jr. (1965). A new construction method for Hadamard matrices.
Bull. Amer. Math. Soc., 71, 169-170

Hedayat, A. and Wallis, W.D. (1978). Hadamard Matrices and Their Application. Ann. Stat., 6, 1184-1238.

London, S. 2013. Constructing New Turyn Type Sequences, T-Sequences and Hadamard Matrices. PhD Thesis, University of Illinois at Chicago, Chicago.
}
