% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FGGM.refit.R
\name{FGGM.refit}
\alias{FGGM.refit}
\title{Refitting of FGGM}
\usage{
FGGM.refit(data, K, lambda1 = 0.5, lambda2 = 0.2, lambda3 = 2, a = 3, rho = 1,
                  eps = 5e-2, niter = 20, maxiter=10, maxiter.AMA=5,
                  initialization=T, initialize, average=F,
                  asymmetric=T, local_appro=T, penalty = "MCP", theta.fusion=T)
}
\arguments{
\item{data}{n * p matrix, the design matrix.}

\item{K}{Int, a selected upper bound of K_0.}

\item{lambda1}{A float value, the tuning parameter controlling the sparse of the mean parameter.}

\item{lambda2}{A float value, the tuning parameter controlling the sparse of the precision matrix.}

\item{lambda3}{A float value, the tuning parameter controlling the number of subgroup.}

\item{a}{A float value, regularization parameter in MCP, the default setting is 3.}

\item{rho}{A float value, the penalty parameter in ADMM algorithm of updating precision matrix Theta, the default setting is 1.}

\item{eps}{A float value, algorithm termination threshold.}

\item{niter}{Int, maximum number of cycles of the algorithm, the default setting is 20.}

\item{maxiter}{Int, maximum number of cycles of the ADMM algorithm.}

\item{maxiter.AMA}{Int, maximum number of cycles of the AMA algorithm.}

\item{initialization}{The logical variable, whether to calculate the initial value, the default setting is T, if initialization = F, the initial value uses initialize.}

\item{initialize}{A given initial value used if initialization = F.}

\item{average}{The logical variable, whether to use averaging when integrating parameters that are identified as identical subgroups, the default setting is F, which means the estimated parameters for the subgroup with the largest sample size among the subgroups identified as identical subgroups is used as the final parameter for this subgroup.}

\item{asymmetric}{The logical variable, symmetry of the precision matrices or not, the default setting is T.}

\item{local_appro}{The logical variable, whether to use local approximations when updating mean parameters, the default setting is T.}

\item{penalty}{The type of the penalty, which can be selected from c("MCP", "SCAD", "lasso").}

\item{theta.fusion}{Whether or not the fusion penalty term contains elements of the precision matrices. The default setting is T.}
}
\value{
A list including all estimated parameters and the BIC value after refitting.
}
\description{
Refitting when K0 is identified using FGGM().
}
\examples{
\donttest{
n <- 200              # The sample size of each subgroup
p <- 20               # The dimension of the precision matrix
K0 <- 3               # The true number of subgroups
N <- rep(n,K0)        # The sample sizes of K0 subgroups
K <- 6                # The given upper bound of K0.

################ The true parameters ################
mue <- 1.5
nonnum <- 4
mu01 <- c(rep(mue,nonnum),rep(-mue,nonnum),rep(0,p-2*nonnum))
mu02 <- c(rep(mue,2*nonnum),rep(0,p-2*nonnum))
mu03 <- c(rep(-mue,2*nonnum),rep(0,p-2*nonnum))
# Power law network
set.seed(2)
A.list <- Power.law.network(p,s=5,I2=c(1),I3=c(2))
Theta01 <- A.list$A1
Theta02 <- A.list$A2
Theta03 <- A.list$A3
sigma01 <- solve(Theta01)
sigma02 <- solve(Theta02)
sigma03 <- solve(Theta03)
Mu0.list <- list(mu01,mu02,mu03)
Sigma0.list <- list(sigma01,sigma02,sigma03)
Theta0.list <- list(Theta01,Theta02,Theta03)

################ Generating simulated data ################
whole.data <- generate.data(N,Mu0.list,Theta0.list,Sigma0.list)

PP = FGGM.refit(whole.data$data, K, lambda1 = 0.22, lambda2 = 0.12, lambda3 = 1.83)
mu_hat=PP$mu; Theta_hat=PP$Xi; L.mat = PP$L.mat0
group = PP$group; prob = PP$prob0; bic = PP$bic; member = PP$member
K0_hat = as.numeric(dim(Theta_hat)[3])
K0_hat
}

}
\references{
Ren, M., Zhang S., Zhang Q. and Ma S. (2020). Gaussian Graphical Model-based Heterogeneity Analysis via Penalized Fusion. Biometrics, Published Online.
}
\author{
Mingyang Ren, Sanguo Zhang, Qingzhao Zhang, Shuangge Ma. Maintainer: Mingyang Ren <renmingyang17@mails.ucas.ac.cn>.
}
