% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coralGetRareSpeciesPriors.R
\name{coralGetRareSpeciesPriors}
\alias{coralGetRareSpeciesPriors}
\title{coralGetRareSpeciesPriors}
\usage{
coralGetRareSpeciesPriors(
  m,
  spNames.rare,
  TrData.rare = NULL,
  phyloTree = NULL,
  C.common.rare = NULL,
  interceptVarInflation = 5
)
}
\arguments{
\item{m}{fitted \code{Hmsc}-class object}

\item{spNames.rare}{vector of species names that are considered rare}

\item{TrData.rare}{dataframe of traits for rare species, if non-trivial traits were used in the backbone Hmsc model}

\item{phyloTree}{phylogeny tree covering both common and rare species}

\item{C.common.rare}{part of phylogeny similarity matrix between common (columns) and rare (rows) species}

\item{interceptVarInflation}{multiplier for conditional variance prior of intercept term in the CORAL prior,
compared to phylogeny-induced conditional prior}
}
\value{
A list containing CORAL prior as matrix of means and matrix of flattened covariances
}
\description{
Constructs CORAL priors
}
\details{
The returned CORAL prior components are matrices with rows corresponding to the rare species from the \code{spNames.rare} argument.
}
