% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanIAT.R
\name{cleanIAT}
\alias{cleanIAT}
\title{Clean IAT data using the updated D-Scoring algorithm}
\usage{
cleanIAT(my_data, block_name, trial_blocks, session_id, trial_latency,
  trial_error, v_error, v_extreme, v_std)
}
\arguments{
\item{my_data}{The raw dataframe to be used}

\item{block_name}{A string of the variable name for the blocks}

\item{trial_blocks}{A vector of the four essential blocks in the seven-block IAT (i.e., B3, B4, B6, and B7).}

\item{session_id}{A string of the variable name identifying each unique participant.}

\item{trial_latency}{A string of the variable name for the latency of each trial.}

\item{trial_error}{A string of the variable name identifying whether a trial was an error or not, where 1 indicates an error.}

\item{v_error}{If 1 (current standard), then means are calculated for the entire set of latencies. If 2, error latencies will be replaced by the block mean + 600ms}

\item{v_extreme}{If 1, then no extreme value treatment. If 2 (current standard), delete trial latencies < 400ms}

\item{v_std}{If 1 (current standard), block SD is performed including error trials (corrected or not). If 2, block SD is performed on correct responses only}
}
\value{
Outputs a dataframe that must be saved to an object. The variable IAT is the calculated D-Score for each individual. SUBEXCL notes
any exclusion criteria, with 0 being inclusion data, 1 for exclusion due to fast response, and 2 for exclusion due to missing blocks. C indicates
standard deviation for combined blocks (correct trial only), while A indicates standard deviations for combined blocks (all trials). M (mean), E (percent error),
N (number of trials used), and F (percent fast responses), are reported for each block included in the original dataframe.
}
\description{
Transform a dataframe with trial latencies (stored as one line per trial) 
for a standard format IAT (7 blocks) into a one line summary per subject of the IAT effect using
the standard scoring algorithm recommended in Greenwald, Nosek, & Banaji (2003). The goal
is to prepare IAT data for subsequent analysis. However, this does not relieve the researcher 
from making conceptual decisions about how best to analyze IAT data. There are decisions to 
make about how the function is applied, and the function does not remove participants.
All subject exclusions must be made deliberately by the researcher. Note that the output of this function
is identical to that of the standard SAS macro (link in reference) for all meaningful columns.
}
\examples{
# Get Ps who recieve Math-Male sorting task in first blocks

cong_first <- IATData[IATData$isCongruentFirst == 1, ]

dscore_first <- cleanIAT(my_data = cong_first,
                         block_name = "BLOCK_NAME_S",
                         trial_blocks = c("BLOCK2", "BLOCK3", "BLOCK5", "BLOCK6"),
                         session_id = "SESSION_ID",
                         trial_latency = "TRIAL_LATENCY",
                         trial_error = "TRIAL_ERROR",
                         v_error = 1, v_extreme = 2, v_std = 1)

# Get Ps who recieve Math-Female sorting task in first blocks

cong_second <- IATData[IATData$isCongruentFirst == 0, ]

dscore_second <- cleanIAT(my_data = cong_second,
                          block_name = "BLOCK_NAME_S",
                          trial_blocks = c("BLOCK2", "BLOCK3", "BLOCK5", "BLOCK6"),
                          session_id = "SESSION_ID",
                          trial_latency = "TRIAL_LATENCY",
                          trial_error = "TRIAL_ERROR",
                          v_error = 1, v_extreme = 2, v_std = 1)

d_score <- rbind(dscore_first, dscore_second)
                                                      
}
\references{
\href{http://faculty.washington.edu/agg/pdf/GB&N.JPSP.2003.pdf}{Understanding and Using the Implicit Association Test: I. An Improved Scoring Algorithm}

\href{http://projectimplicit.net/nosek/papers/scoringalgorithm.sas.txt}{IAT SAS macro}
}

