% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd_lookup.R
\name{icd_lookup}
\alias{icd_lookup}
\title{Lookup an ICD-10 code in R}
\usage{
icd_lookup(icd, year = NULL, expand = TRUE)
}
\arguments{
\item{icd}{ICD code to look up (any format that can be recognised by \code{icd_parse})}

\item{year}{ICD-10-GM version to use (Default: most recent year available)}

\item{expand}{Should all subcodes of the given code be returned? (Default: TRUE)}
}
\value{
A tibble with three columns: (year, icd_sub, label) and one row for each result
}
\description{
This is a convenience function to quickly look up the label associated with
one or more ICD-10 codes. By default, it performs the lookup using the most
recent version of the ICD-10-GM available.
}
\details{
This is a convenience function intended for interactive use. The browser will
only be opened if R is being used interactively. The function always returns
invisibly the URL of the page to be opened.
}
\examples{
icd_lookup("E10.9")

}
\seealso{
\code{\link[=icd_search]{icd_search()}} to search for a string in the ICD-10-GM labels
\code{\link[=icd_browse]{icd_browse()}} to lookup an ICD-10-GM code in the official BfArM documentation, opening the page in a browser
}
