% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICcforest-package.R
\docType{package}
\name{ICcforest-package}
\alias{ICcforest-package}
\title{Construct a conditional inference forest model for interval-censored survival data}
\description{
Construct a conditional inference forest model for interval-censored survival data.
The main function of this package is \code{\link{ICcforest}}.
}
\details{
\subsection{Problem setup and existing methods}{
In many situations, the survival time cannot be directly observed and it is only 
known to have occurred in an interval obtained from a sequence of examination times. 
Methods like the Cox proportional hazards model rely on restrictive assumptions such as 
proportional hazards and a log-linear relationship between the hazard function and 
covariates. Furthermore, because these methods are often parametric, nonlinear effects 
of variables must be modeled by transformations or expanding the design matrix to 
include specialized basis functions for more complex data structures in real world 
applications. The function \code{\link[LTRCtrees]{ICtree}} in the \code{LTRCtrees}
package provides a conditional inference tree method for interval-censored survival data, 
as an extension of the conditional inference tree method \code{\link[partykit]{ctree}}
for right-censored data. Tree estimators are nonparametric and as such often exhibit 
low bias and high variance. Ensemble methods like bagging and random forest can 
reduce variance while preserving low bias.}

\subsection{ICcforest model}{
This package implements \code{\link{ICcforest}}, which extends the conditional inference forest 
(see \code{\link[partykit]{cforest}}) to interval censored data. \code{\link{ICcforest}} uses 
conditional inference survival trees (see \code{\link[LTRCtrees]{ICtree}}) as base learners. 
The main function \code{\link{ICcforest}} fits a 
conditional inference forest for interval-censored survival data, with parameter 
\code{mtry} tuned by \code{\link{tuneICRF}}; \code{\link{gettree.ICcforest}} extracts 
the i-th individual tree from the established \code{ICcforest} objects; and 
\code{\link{predict.ICcforest}} computes predictions from \code{ICcforest} objects.}
}
\seealso{
\code{\link{ICcforest}, \link{gettree.ICcforest}, \link{predict.ICcforest},  
\link{tuneICRF}, \link{sbrier_IC}}
}
\keyword{package}
