% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{sol_path_pcm}
\alias{sol_path_pcm}
\title{The solution path for the case of piecewise-constant signals}
\usage{
sol_path_pcm(x, thr_ic = 0.9, points = 3)
}
\arguments{
\item{x}{A numeric vector containing the data in which you would like to find
change-points.}

\item{thr_ic}{A positive real number with default value equal to 0.9. It is
used to define the threshold. The change-points are estimated by thresholding
with threshold equal to \code{sigma * thr_ic * sqrt(2 * log(T))}, where
\code{T} is the length of the data sequence \code{x} and \code{sigma = mad(diff(x)/sqrt(2))}.
Because we would like to overestimate the number of true change-points in \code{x}, it is
suggested to keep \code{thr_ic} smaller than 1, which is the default value used as
the threshold constant in the function \code{\link{pcm_th}}.}

\item{points}{A positive integer with default value equal to 3. It defines
the distance between two consecutive end- or start-points of the right- or
left-expanding intervals, respectively.}
}
\value{
The solution path for the case of piecewise-constant signals.
}
\description{
This function starts by overestimating the number of true change-points.
After that, following a CUSUM-based approach, it sorts the estimated change-points
in a way that the estimate, which is most-likely to be correct appears first, whereas
the least likely to be correct, appears last. The routine is typically not called
directly by the user; it is employed in \code{\link{pcm_ic}}. For more information, see
References.
}
\examples{
three.cpt <- c(rep(4,4000),rep(0,4000),rep(-4,4000),rep(1,4000))
three.cpt.noise <- three.cpt + rnorm(16000)
solution.path <- sol_path_pcm(three.cpt.noise)
}
\references{
Anastasiou, A. and Fryzlewicz, P. (2018). Detecting multiple generalized change-points
by isolating single ones.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
