% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcHM.R
\name{calcHM}
\alias{calcHM}
\title{Calculate information capacity (HM)}
\usage{
calcHM(df)
}
\arguments{
\item{df}{A data frame with the first column indicating individual identity.}
}
\value{
Numeric value. Individual identity information capacity HM (in bits) in dataset.
}
\description{
This function calculates information capacity of a signal. \cr\cr
\strong{Reference:} Searby, A., & Jouventin, P. (2004). How to measure
information carried by a modulated vocal signature? Journal of the Acoustical
Society of America, 116, 3192-3198. doi:10.1121/1.1775271 \cr\cr
}
\examples{
calcHM(ANmodulation)

}
\seealso{
Other individual identity metrics: \code{\link{calcDS}},
  \code{\link{calcF}}, \code{\link{calcHSngroups}},
  \code{\link{calcHSnpergroup}}, \code{\link{calcHSntot}},
  \code{\link{calcHSvarcomp}}, \code{\link{calcHS}},
  \code{\link{calcMI}}, \code{\link{calcPICbetweenmeans}},
  \code{\link{calcPICbetweentot}}, \code{\link{calcPIC}}
}
\concept{individual identity metrics}
