% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IFMCDM.r
\name{IFTOPSIS}
\alias{IFTOPSIS}
\title{Implementation of the Intuitionistic Fuzzy Technique for Order of Preference by Similarity to Ideal Solution for Fuzzy Multi-Criteria  Decision Making Problems}
\usage{
IFTOPSIS(
  data,
  d = "e",
  w = rep(3/ncol(data), ncol(data)/3),
  z = rep("b", ncol(data)/3),
  p = "dataBounds",
  ap = "dataBounds"
)
}
\arguments{
\item{data}{The data matrix (\emph{m} x \emph{n*3}) with the values of  \emph{mi} \emph{ni} and \emph{pi} (three columns for each intuitionistic fuzzy representation of criteria for each alternative), where \emph{m} is the number of alternatives and \emph{n} is the number of criteria.}

\item{d}{Distance "euclidean" or "hamming".}

\item{w}{A vector of length \emph{n}, containing the crisp weights for the criteria (one value for intuitionistic fuzzy representation)}

\item{z}{A vector  of length \emph{n},  with preferences type for each criterion with "b" (benefit) and "c" (cost).}

\item{p}{Ideal point calculation type with one of two values: "dataBounds" – ideal point contains max and min values from the dataset – see details; "idealBounds" – ideal point contains 1 and 0’s - see details.}

\item{ap}{Anti-ideal point calculation type with one of two values: "dataBounds" – anti-ideal point contains min and max from the dataset – see details; "idealBounds" – anti-ideal point contains 0 and 1’s - see details.}
}
\value{
\code{IFTOPSIS} returns a data frame that contains the scores of the Intuitionistic Fuzzy Technique for Order of Preference by Similarity to Ideal Solution (IFTOPSIS) and the ranking of the alternatives.
}
\description{
The \code{IFTOPSIS} -  Intuitionistic Fuzzy Technique for Order of Preference by Similarity to Ideal Solution for Fuzzy Multi-Criteria  Decision Making. Reference describing the method: Roszkowska, Kusterka-Jefmańska, Jefmański (2021) \doi{10.3390/e23050563}
}
\details{
For p="dataBounds"  the actual ideal point is calculated for benefits  as maximum from all values for \emph{mi} and min for \emph{ni} (\emph{pi} = 1- \emph{mi} - \emph{ni}); in the case of costs, minimal value for \emph{mi} and max for \emph{ni} (\emph{pi} = 1- \emph{mi} - \emph{ni}).
For p="idealBounds" for benefitss is 1 for \emph{mi} and 0 for \emph{ni} (\emph{pi} = 1- \emph{mi} - \emph{ni} ). In the case of costs it is 0 for \emph{mi} and 1 for \emph{ni} (\emph{pi} = 1- (\emph{mi} - \emph{ni}).
For ap="dataBounds" the actual anti-ideal point is calculated for benefit criteria as minimum of all values for \emph{mi},  maximum of all values for \emph{ni} and \emph{pi} = 1- (\emph{mi} + \emph{ni}); in the case of cost criteria, maximum of all values for \emph{mi},
minimum of all values   for \emph{ni} and \emph{pi} = 1- (\emph{mi} + \emph{ni}).
For ap="idealBounds" in the case of benefit criteria it is 0 for \emph{mi},
1 for \emph{ni}, 0 for \emph{pi}; in the case of cost criteria it is 1 for \emph{mi}, 0 for \emph{ni} and 0 for \emph{pi}.
}
\examples{
set.seed(823)
data<-sample(1:7,26*13*8,replace=TRUE)
dim(data)<-c(26*13,8)
nrColumns<-8
primary<-data.frame(name=rep(LETTERS,each=13),data)
f<-IFconversion(primary)
m<-IFTOPSIS(f)
print(m)
}
\references{
Roszkowska E, Kusterka-Jefmańska M, Jefmański B. Intuitionistic Fuzzy TOPSIS as a Method for Assessing Socioeconomic Phenomena on the Basis of Survey Data. Entropy. 2021; 23(5):563. \doi{10.3390/e23050563}

Xu, Z. Some Similarity Measures of Intuitionistic Fuzzy Sets and Their Applications to Multiple Attribute Decision Making. Fuzzy Optimization and Decision Making. 2007; 6: 109–121. \doi{10.1007/s10700-007-9004-z}
}
