% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/role_sim.R
\name{role_sim}
\alias{role_sim}
\title{Similarity of roles of interconnecting species}
\usage{
role_sim(spe_role_mat)
}
\arguments{
\item{spe_role_mat}{A matrix of 70 columns representing the roles of
interconnecting species in the motifs. Columns names are Role1, Role2,
Role3 ... Role70.}
}
\value{
Return a numeric value.
}
\description{
The average of Similarity of 65 roles of interconnecting species of
tripartite network.
}
\details{
\strong{spe_role_mat}

Should acquire from function \code{motif_role}.
}
\examples{

## generate a random tripartite network
set.seed(12)
Net <- build_toy_net(11,15,16,0.2)
role_sim(icmotif_role(Net))

data(PPH_Coltparkmeadow)
Net <- PPH_Coltparkmeadow
role_sim(icmotif_role(Net))




}
