% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-McKinsey.R
\docType{data}
\name{McKinsey}
\alias{McKinsey}
\title{McKinsey / OECD Education Dataset}
\format{
A data frame with the following variables:
\describe{
\item{COUNTRIES}{The name of the country.}
\item{READING}{Teacher efficiency measured by PISA reading tests.}
\item{YSALARY}{Teacher salaries in relation to GDP per capita.
0 means salaries equal GDP per capita, 0.5 means 1.5 times higher than GDP per capita,
1 means 2 times higher than GDP per capita.}
\item{YGDP}{GDP per capita in USD 1,000.}
\item{EXPEND}{Cumulative expenditure by educational establishments in USD 1,000.}
\item{PERF}{Teacher merit pay (y = yes, n = no).}
}
}
\source{
\itemize{
\item McKinsey, "Valuing the merit of teachers", Direction interministérielle de la transformation publique.
\item OECD (2012), "Does Performance-Based Pay Improve Teaching?", PISA in Focus, No. 16, OECD Publishing, Paris, \doi{10.1787/5k98q27r2stb-en}
}
}
\usage{
data(McKinsey)
}
\description{
Dataset combining information from:
\itemize{
\item McKinsey, "Valuing the merit of teachers", Direction interministérielle de la transformation publique.
\item OECD (2012), "Does Performance-Based Pay Improve Teaching?", PISA in Focus, No. 16, OECD Publishing, Paris.
}
}
\details{
The dataset contains teacher efficiency as measured by reading performance on PISA tests,
along with explanatory variables related to salary, GDP, expenditures, and performance-based pay.
}
\keyword{datasets}
