% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getpoints.R
\name{getpoints}
\alias{getpoints}
\title{Extract the coordinates from Kaplan-Meier(K-M) curves by mouse-clicks}
\usage{
getpoints(f,x1,x2,y1,y2)
}
\arguments{
\item{f}{the bitmap image(in JPEG,PNG,BMP,JPG or TIFF formate) of the K-M curves. The input can be either the pathway to the image file, or the bitmap digital image itself.}

\item{x1}{two points needed to decide the postion and scale of the x-axis. Here x1 is the actual x-coordinate of the right point on x-axis}

\item{x2}{two points needed to decide the postion and scale of the x-axis. Here x2 is the actual x-coordinate of the left point on x-axis}

\item{y1}{two points needed to decide the postion and scale of the y-axis. Here y1 is the actual y-coordinate of the lower point on y-axis}

\item{y2}{two points needed to decide the postion and scale of the y-axis. Here y2 is the actual y-coordinate of the upper point on y-axis}
}
\value{
\code{getpoints()} returns a two-column dataset of coordinates extracted from a K-M curve.\cr \cr
}
\description{
The \code{getpoints()} function extracts the coordinates from K-M curves by mouse-clicks. The K-M curves should be in the format of bitmap images(in JPEG,PNG,BMP,JPG or TIFF),
            and the use of .png file is highly recommended, since it can greatly shorten the processing time in R. \cr\cr
            In addition to the image itself, the input of the \code{getpoints()} function includes two x-coordinates (x1 and x2) and two y-coordinates to decide the location and scale of the curve. Once the
            image is read into R and displayed in the plots window, firstly the user need to click on the four points on the x-axis and y-axis according to the input, and in the order of (x1,x2,y1,and y2); secondly, the user need to collect the points coordinates by
            mouse-clicks on the curve. To get desirable estimation, we suggest collecting 80-100 points on each curve, and including the points where the survival probability drops. The output of this function is a two-column dataset of coordinates extracted from the K-M curve.
}
\examples{
str(imgexp)
\donttest{

## Extract the coordinates from Kaplan-Meier(K-M) curves by mouse-clicks.
## The K-M curve should be in the format of bitmap images. The input f should be either
## the pathway to the image file, or the bitmap digital image itself.
## Example: extract coordinates from the sample bitmap digital image (imgexp)
plot.new()
rasterImage(imgexp, 0, 0, 1, 1)
## User need to use mouse-clicks to decide the positions of coordinates,
## and the points want to extract.
df <- getpoints(imgexp,0,60,0,100)
head(df)
## the extracted dataset df can be used to estimate IPD by other functions in the package
trisk <- Radiationdata$trisk
nrisk.radio <- Radiationdata$nrisk.radio
pre_radio <- preprocess(dat=df, trisk=trisk,
             nrisk=nrisk.radio,totalpts=NULL,maxy=100)
est_radio <- getIPD(prep=pre_radio,armID=0,tot.events=NULL)
}

}
\references{
Poisot T. The digitize package: extracting numerical data from scatterplots. The R Journal. 2011 Jun 1;3(1):25-6.
}
