% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_score.R
\name{adaptive_test}
\alias{adaptive_test}
\title{Ability parameter estimation with fixed item parameters}
\usage{
adaptive_test(
  response,
  item,
  model = "dich",
  ability_method = "EAP",
  quad = NULL,
  prior = NULL
)
}
\arguments{
\item{response}{A matrix of item responses. For mixed-format test, a list
of item responses where dichotomous item responses are the first element and
polytomous item responses are the second element.}

\item{item}{A matrix of item parameters. For mixed-format test, a list
of item parameters where dichotomous item parameters are the first element and
polytomous item parameters are the second element.}

\item{model}{\code{dich} for dichotomous items,
\code{cont} for continuous items, and a specific item response model
(e.g., \code{PCM}, \code{GPCM}, \code{GRM}) for polytomous items and a mixed-format test.
The default is \code{dich}.}

\item{ability_method}{The ability parameter estimation method.
The available options are Expected \emph{a posteriori} (\code{EAP}), Maximum Likelihood Estimates (\code{MLE}), and weighted likelihood estimates (\code{WLE}).
The default is \code{EAP}.}

\item{quad}{A vector of quadrature points for \code{EAP} calculation.
If \code{NULL} is passed, it is set as \code{seq(-6,6,length.out=121)}. The default is \code{NULL}.}

\item{prior}{A vector of the prior distribution for \code{EAP} calculation. The length of it should be the same as \code{quad}.
If \code{NULL} is passed, the standard normal distribution is used. The default is \code{NULL}.}
}
\value{
\item{theta}{The estimated ability parameter values. If \code{ability_method = "MLE"}.
If an examinee receives a maximum or minimum score for all items, the function returns \eqn{\pm}\code{Inf}.}
\item{theta_se}{The standard errors of ability parameter estimates.
It returns standard deviations of posteriors for \code{EAP}s and asymptotic standard errors (i.e., square root of inverse Fisher information) for \code{MLE}.
If an examinee receives a maximum or minimum score for all items, the function returns \code{NA} for \code{MLE}.}
}
\description{
Ability parameter estimation when item responses and item parameters are given.
This function can be useful in ability parameter estimation is adaptive testing.
}
\examples{
\donttest{

# dichotomous

response <- c(1,1,0)
item <- matrix(
  c(
      1, -0.5,   0,
    1.5,   -1,   0,
    1.2,    0, 0.2
  ), nrow = 3, byrow = TRUE
)
adaptive_test(response, item, model = "dich", ability_method = "WLE")


# polytomous

response <- c(1,2,0)
item <- matrix(
    c(
      1, -0.5, 0.5,
    1.5,   -1,   0,
    1.2,    0, 0.4
    ), nrow = 3, byrow = TRUE
  )
adaptive_test(response, item, model="GPCM", ability_method = "WLE")


# mixed-format test

response <- list(c(0,0,0),c(2,2,1))
item <- list(
  matrix(
    c(
        1, -0.5, 0,
      1.5,   -1, 0,
      1.2,    0, 0
    ), nrow = 3, byrow = TRUE
  ),
  matrix(
    c(
        1, -0.5, 0.5,
      1.5,   -1,   0,
      1.2,    0, 0.4
    ), nrow = 3, byrow = TRUE
  )
)
adaptive_test(response, item, model = "GPCM", ability_method = "WLE")


# continuous response

response <- c(0.88, 0.68, 0.21)
item <- matrix(
  c(
    1, -0.5, 10,
    1.5,   -1,  8,
    1.2,    0, 11
  ), nrow = 3, byrow = TRUE
)
adaptive_test(response, item, model = "cont", ability_method = "WLE")
}
}
\author{
Seewoo Li \email{cu@yonsei.ac.kr}
}
