% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.irtest.R
\name{summary.IRTest}
\alias{summary.IRTest}
\title{Summary of the results}
\usage{
\method{summary}{IRTest}(object, ...)
}
\arguments{
\item{object}{An object of \code{"IRTest"}-class obtained from either \code{\link{IRTest_Dich}}, \code{\link{IRTest_Poly}}, or \code{\link{IRTest_Mix}}.}

\item{...}{Other argument(s).}
}
\value{
Summarized information.
}
\description{
This function summarizes the output (e.g., convergence of the estimation algorithm, number of parameters, model-fit, and estimated latent distribution).
}
\examples{
\donttest{
data <- DataGeneration(N=1000, nitem_P = 8)$data_P

M1 <- IRTest_Poly(data = data, latent_dist = "KDE")

summary(M1)
}
}
