% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVC.R
\name{IVC_Interval}
\alias{IVC_Interval}
\title{Integrated Variance Correlation for Interval Independence}
\usage{
IVC_Interval(y, x, K, tau1, tau2, NN = 3, type)
}
\arguments{
\item{y}{is a numeric vector}

\item{x}{is a numeric vector or a data matrix}

\item{K}{is the number of quantile levels}

\item{tau1}{is the minimum quantile level}

\item{tau2}{is the maximum quantile level}

\item{NN}{is the number of B spline basis, default is 3}

\item{type}{is an indicator for measuring linear or nonlinear correlation, "linear" represents linear correlation and "nonlinear" represents linear or nonlinear correlation using B splines}
}
\value{
The value of the corresponding sample statistic for interval independence
}
\description{
This function is used to calculate the integrated variance correlation to measure interval independence
}
\examples{
# linear model
require("mvtnorm")
n=100
p=3
pho1=0.5
mean_x=rep(0,p)
sigma_x=matrix(NA,nrow = p,ncol = p)
for (i in 1:p) {
 for (j in 1:p) {
   sigma_x[i,j]=pho1^(abs(i-j))
 }
}
x=rmvnorm(n, mean = mean_x, sigma = sigma_x,method = "chol")
y=2*(x[,1]+x[,2]+x[,3])+rnorm(n)

IVC_Interval(y,x,K=5,tau1=0.4,tau2=0.6,type="linear")
# nonlinear model
n=100
x=runif(n,min=-2,max=2)
y=exp(x^2)*rnorm(n)

IVC_Interval(y,x,K=5,tau1=0.4,tau2=0.6,type="nonlinear")
}
