/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix1D;

public class WrapperFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix1D content;

    public WrapperFComplexMatrix1D(FComplexMatrix1D fComplexMatrix1D) {
        if (fComplexMatrix1D != null) {
            this.setUp((int)fComplexMatrix1D.size());
        }
        this.content = fComplexMatrix1D;
    }

    protected FComplexMatrix1D getContent() {
        return this.content;
    }

    public synchronized float[] getQuick(int n) {
        return this.content.getQuick(n);
    }

    public Object elements() {
        return this.content.elements();
    }

    public FComplexMatrix1D like(int n) {
        return this.content.like(n);
    }

    public FComplexMatrix2D like2D(int n, int n2) {
        return this.content.like2D(n, n2);
    }

    public FComplexMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public FComplexMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public synchronized void setQuick(int n, float[] fArray) {
        this.content.setQuick(n, fArray);
    }

    public synchronized void setQuick(int n, float f, float f2) {
        this.content.setQuick(n, f, f2);
    }

    public FComplexMatrix1D viewFlip() {
        WrapperFComplexMatrix1D wrapperFComplexMatrix1D = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n) {
                return this.content.getQuick(this.size - 1 - n);
            }

            public synchronized void setQuick(int n, float[] fArray) {
                this.content.setQuick(this.size - 1 - n, fArray);
            }

            public synchronized void setQuick(int n, float f, float f2) {
                this.content.setQuick(this.size - 1 - n, f, f2);
            }

            public synchronized float[] get(int n) {
                return this.content.get(this.size - 1 - n);
            }

            public synchronized void set(int n, float[] fArray) {
                this.content.set(this.size - 1 - n, fArray);
            }

            public synchronized void set(int n, float f, float f2) {
                this.content.set(this.size - 1 - n, f, f2);
            }
        };
        return wrapperFComplexMatrix1D;
    }

    public FComplexMatrix1D viewPart(final int n, int n2) {
        this.checkRange(n, n2);
        WrapperFComplexMatrix1D wrapperFComplexMatrix1D = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n2) {
                return this.content.getQuick(n + n2);
            }

            public synchronized void setQuick(int n2, float[] fArray) {
                this.content.setQuick(n + n2, fArray);
            }

            public synchronized void setQuick(int n2, float f, float f2) {
                this.content.setQuick(n + n2, f, f2);
            }

            public synchronized float[] get(int n2) {
                return this.content.get(n + n2);
            }

            public synchronized void set(int n2, float[] fArray) {
                this.content.set(n + n2, fArray);
            }

            public synchronized void set(int n2, float f, float f2) {
                this.content.set(n + n2, f, f2);
            }
        };
        wrapperFComplexMatrix1D.size = n2;
        return wrapperFComplexMatrix1D;
    }

    public FComplexMatrix1D viewSelection(int[] nArray) {
        if (nArray == null) {
            nArray = new int[this.size];
            int n = this.size;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        this.checkIndexes(nArray);
        final int[] nArray2 = nArray;
        WrapperFComplexMatrix1D wrapperFComplexMatrix1D = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n) {
                return this.content.getQuick(nArray2[n]);
            }

            public synchronized void setQuick(int n, float[] fArray) {
                this.content.setQuick(nArray2[n], fArray);
            }

            public synchronized void setQuick(int n, float f, float f2) {
                this.content.setQuick(nArray2[n], f, f2);
            }

            public synchronized float[] get(int n) {
                return this.content.get(nArray2[n]);
            }

            public synchronized void set(int n, float[] fArray) {
                this.content.set(nArray2[n], fArray);
            }

            public synchronized void set(int n, float f, float f2) {
                this.content.set(nArray2[n], f, f2);
            }
        };
        wrapperFComplexMatrix1D.size = nArray.length;
        return wrapperFComplexMatrix1D;
    }

    protected FComplexMatrix1D viewSelectionLike(int[] nArray) {
        throw new InternalError();
    }

    public FComplexMatrix1D viewStrides(final int n) {
        if (this.stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + this.stride);
        }
        WrapperFComplexMatrix1D wrapperFComplexMatrix1D = new WrapperFComplexMatrix1D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n2) {
                return this.content.getQuick(n2 * n);
            }

            public synchronized void setQuick(int n2, float[] fArray) {
                this.content.setQuick(n2 * n, fArray);
            }

            public synchronized void setQuick(int n2, float f, float f2) {
                this.content.setQuick(n2 * n, f, f2);
            }

            public synchronized float[] get(int n2) {
                return this.content.get(n2 * n);
            }

            public synchronized void set(int n2, float[] fArray) {
                this.content.set(n2 * n, fArray);
            }

            public synchronized void set(int n2, float f, float f2) {
                this.content.set(n2 * n, f, f2);
            }
        };
        if (this.size != 0) {
            wrapperFComplexMatrix1D.size = (this.size - 1) / n + 1;
        }
        return wrapperFComplexMatrix1D;
    }

    public FloatMatrix1D getImaginaryPart() {
        return this.content.getImaginaryPart();
    }

    public FloatMatrix1D getRealPart() {
        return this.content.getRealPart();
    }
}

