/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DelegateFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseLargeFComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatMatrix3D;
import cern.colt.matrix.tfloat.impl.DenseLargeFloatMatrix3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class WrapperFComplexMatrix3D
extends FComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    protected FComplexMatrix3D content;

    public WrapperFComplexMatrix3D(FComplexMatrix3D fComplexMatrix3D) {
        if (fComplexMatrix3D != null) {
            this.setUp(fComplexMatrix3D.slices(), fComplexMatrix3D.rows(), fComplexMatrix3D.columns());
        }
        this.content = fComplexMatrix3D;
    }

    public Object elements() {
        return this.content.elements();
    }

    public void fft2Slices() {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).fft2Slices();
            } else {
                DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = (DenseLargeFComplexMatrix3D)this.copy();
                denseLargeFComplexMatrix3D.fft2Slices();
                this.assign(denseLargeFComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void fft3() {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).fft3();
            } else {
                DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = (DenseLargeFComplexMatrix3D)this.copy();
                denseLargeFComplexMatrix3D.fft3();
                this.assign(denseLargeFComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft2Slices(boolean bl) {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).ifft2Slices(bl);
            } else {
                DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = (DenseLargeFComplexMatrix3D)this.copy();
                denseLargeFComplexMatrix3D.ifft2Slices(bl);
                this.assign(denseLargeFComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public void ifft3(boolean bl) {
        if (this.content instanceof DenseLargeFComplexMatrix3D) {
            if (this.isNoView) {
                ((DenseLargeFComplexMatrix3D)this.content).ifft3(bl);
            } else {
                DenseLargeFComplexMatrix3D denseLargeFComplexMatrix3D = (DenseLargeFComplexMatrix3D)this.copy();
                denseLargeFComplexMatrix3D.ifft3(bl);
                this.assign(denseLargeFComplexMatrix3D);
            }
        } else {
            throw new IllegalArgumentException("This method is not supported");
        }
    }

    public synchronized float[] getQuick(int n, int n2, int n3) {
        return this.content.getQuick(n, n2, n3);
    }

    public FComplexMatrix3D like(int n, int n2, int n3) {
        return this.content.like(n, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
        this.content.setQuick(n, n2, n3, fArray);
    }

    public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
        this.content.setQuick(n, n2, n3, f, f2);
    }

    public FComplexMatrix1D vectorize() {
        DenseFComplexMatrix1D denseFComplexMatrix1D = new DenseFComplexMatrix1D((int)this.size());
        int n = this.rows * this.columns;
        for (int i = 0; i < this.slices; ++i) {
            denseFComplexMatrix1D.viewPart(i * n, n).assign(this.viewSlice(i).vectorize());
        }
        return denseFComplexMatrix1D;
    }

    public FComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        return new DelegateFComplexMatrix2D(this, 2, n);
    }

    public FComplexMatrix3D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        WrapperFComplexMatrix3D wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, n2, this.columns - 1 - n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, fArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                this.content.setQuick(n, n2, this.columns - 1 - n3, f, f2);
            }

            public synchronized float[] get(int n, int n2, int n3) {
                return this.content.get(n, n2, this.columns - 1 - n3);
            }

            public synchronized void set(int n, int n2, int n3, float[] fArray) {
                this.content.set(n, n2, this.columns - 1 - n3, fArray);
            }

            public synchronized void set(int n, int n2, int n3, float f, float f2) {
                this.content.set(n, n2, this.columns - 1 - n3, f, f2);
            }
        };
        wrapperFComplexMatrix3D.isNoView = false;
        return wrapperFComplexMatrix3D;
    }

    public FComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        return new DelegateFComplexMatrix2D(this, 0, n);
    }

    public FComplexMatrix3D viewSliceFlip() {
        if (this.slices == 0) {
            return this;
        }
        WrapperFComplexMatrix3D wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(this.slices - 1 - n, n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, fArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                this.content.setQuick(this.slices - 1 - n, n2, n3, f, f2);
            }

            public synchronized float[] get(int n, int n2, int n3) {
                return this.content.get(this.slices - 1 - n, n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, float[] fArray) {
                this.content.set(this.slices - 1 - n, n2, n3, fArray);
            }

            public synchronized void set(int n, int n2, int n3, float f, float f2) {
                this.content.set(this.slices - 1 - n, n2, n3, f, f2);
            }
        };
        wrapperFComplexMatrix3D.isNoView = false;
        return wrapperFComplexMatrix3D;
    }

    public FComplexMatrix3D viewDice(int n, int n2, int n3) {
        int n4 = 3;
        if (n < 0 || n >= n4 || n2 < 0 || n2 >= n4 || n3 < 0 || n3 >= n4 || n == n2 || n == n3 || n2 == n3) {
            throw new IllegalArgumentException("Illegal Axes: " + n + ", " + n2 + ", " + n3);
        }
        WrapperFComplexMatrix3D wrapperFComplexMatrix3D = null;
        if (n == 0 && n2 == 1 && n3 == 2) {
            wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this);
        } else if (n == 1 && n2 == 0 && n3 == 2) {
            wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n, n3);
                }

                public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                    this.content.setQuick(n2, n, n3, fArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                    this.content.setQuick(n2, n, n3, f, f2);
                }

                public synchronized float[] get(int n, int n2, int n3) {
                    return this.content.get(n2, n, n3);
                }

                public synchronized void set(int n, int n2, int n3, float[] fArray) {
                    this.content.set(n2, n, n3, fArray);
                }

                public synchronized void set(int n, int n2, int n3, float f, float f2) {
                    this.content.set(n2, n, n3, f, f2);
                }
            };
        } else if (n == 1 && n2 == 2 && n3 == 0) {
            wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n2, n3, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                    this.content.setQuick(n2, n3, n, fArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                    this.content.setQuick(n2, n3, n, f, f2);
                }

                public synchronized float[] get(int n, int n2, int n3) {
                    return this.content.get(n2, n3, n);
                }

                public synchronized void set(int n, int n2, int n3, float[] fArray) {
                    this.content.set(n2, n3, n, fArray);
                }

                public synchronized void set(int n, int n2, int n3, float f, float f2) {
                    this.content.set(n2, n3, n, f, f2);
                }
            };
        } else if (n == 2 && n2 == 1 && n3 == 0) {
            wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n2, n);
                }

                public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                    this.content.setQuick(n3, n2, n, fArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                    this.content.setQuick(n3, n2, n, f, f2);
                }

                public synchronized float[] get(int n, int n2, int n3) {
                    return this.content.get(n3, n2, n);
                }

                public synchronized void set(int n, int n2, int n3, float[] fArray) {
                    this.content.set(n3, n2, n, fArray);
                }

                public synchronized void set(int n, int n2, int n3, float f, float f2) {
                    this.content.set(n3, n2, n, f, f2);
                }
            };
        } else if (n == 2 && n2 == 0 && n3 == 1) {
            wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
                private static final long serialVersionUID = 1L;

                public synchronized float[] getQuick(int n, int n2, int n3) {
                    return this.content.getQuick(n3, n, n2);
                }

                public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                    this.content.setQuick(n3, n, n2, fArray);
                }

                public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                    this.content.setQuick(n3, n, n2, f, f2);
                }

                public synchronized float[] get(int n, int n2, int n3) {
                    return this.content.get(n3, n, n2);
                }

                public synchronized void set(int n, int n2, int n3, float[] fArray) {
                    this.content.set(n3, n, n2, fArray);
                }

                public synchronized void set(int n, int n2, int n3, float f, float f2) {
                    this.content.set(n3, n, n2, f, f2);
                }
            };
        }
        int[] nArray = this.shape();
        wrapperFComplexMatrix3D.slices = nArray[n];
        wrapperFComplexMatrix3D.rows = nArray[n2];
        wrapperFComplexMatrix3D.columns = nArray[n3];
        wrapperFComplexMatrix3D.isNoView = false;
        return wrapperFComplexMatrix3D;
    }

    public FComplexMatrix3D viewPart(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        this.checkBox(n, n2, n3, n4, n5, n6);
        WrapperFComplexMatrix3D wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, float[] fArray) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, fArray);
            }

            public synchronized void setQuick(int n4, int n22, int n32, float f, float f2) {
                this.content.setQuick(n + n4, n2 + n22, n3 + n32, f, f2);
            }

            public synchronized float[] get(int n4, int n22, int n32) {
                return this.content.get(n + n4, n2 + n22, n3 + n32);
            }

            public synchronized void set(int n4, int n22, int n32, float[] fArray) {
                this.content.set(n + n4, n2 + n22, n3 + n32, fArray);
            }

            public synchronized void set(int n4, int n22, int n32, float f, float f2) {
                this.content.set(n + n4, n2 + n22, n3 + n32, f, f2);
            }
        };
        wrapperFComplexMatrix3D.slices = n4;
        wrapperFComplexMatrix3D.rows = n5;
        wrapperFComplexMatrix3D.columns = n6;
        wrapperFComplexMatrix3D.isNoView = false;
        return wrapperFComplexMatrix3D;
    }

    public FComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        return new DelegateFComplexMatrix2D(this, 1, n);
    }

    public FComplexMatrix3D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        WrapperFComplexMatrix3D wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(n, this.rows - 1 - n2, n3);
            }

            public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, fArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                this.content.setQuick(n, this.rows - 1 - n2, n3, f, f2);
            }

            public synchronized float[] get(int n, int n2, int n3) {
                return this.content.get(n, this.rows - 1 - n2, n3);
            }

            public synchronized void set(int n, int n2, int n3, float[] fArray) {
                this.content.set(n, this.rows - 1 - n2, n3, fArray);
            }

            public synchronized void set(int n, int n2, int n3, float f, float f2) {
                this.content.set(n, this.rows - 1 - n2, n3, f, f2);
            }
        };
        wrapperFComplexMatrix3D.isNoView = false;
        return wrapperFComplexMatrix3D;
    }

    public FComplexMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        if (nArray == null) {
            nArray = new int[this.slices];
            n = this.slices;
            while (--n >= 0) {
                nArray[n] = n;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n = this.rows;
            while (--n >= 0) {
                nArray2[n] = n;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n = this.columns;
            while (--n >= 0) {
                nArray3[n] = n;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        final int[] nArray4 = nArray;
        final int[] nArray5 = nArray2;
        final int[] nArray6 = nArray3;
        WrapperFComplexMatrix3D wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n, int n2, int n3) {
                return this.content.getQuick(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void setQuick(int n, int n2, int n3, float[] fArray) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], fArray);
            }

            public synchronized void setQuick(int n, int n2, int n3, float f, float f2) {
                this.content.setQuick(nArray4[n], nArray5[n2], nArray6[n3], f, f2);
            }

            public synchronized float[] get(int n, int n2, int n3) {
                return this.content.get(nArray4[n], nArray5[n2], nArray6[n3]);
            }

            public synchronized void set(int n, int n2, int n3, float[] fArray) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], fArray);
            }

            public synchronized void set(int n, int n2, int n3, float f, float f2) {
                this.content.set(nArray4[n], nArray5[n2], nArray6[n3], f, f2);
            }
        };
        wrapperFComplexMatrix3D.slices = nArray.length;
        wrapperFComplexMatrix3D.rows = nArray2.length;
        wrapperFComplexMatrix3D.columns = nArray3.length;
        wrapperFComplexMatrix3D.isNoView = false;
        return wrapperFComplexMatrix3D;
    }

    public FComplexMatrix3D viewStrides(final int n, final int n2, final int n3) {
        if (n <= 0 || n2 <= 0 || n3 <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperFComplexMatrix3D wrapperFComplexMatrix3D = new WrapperFComplexMatrix3D(this){
            private static final long serialVersionUID = 1L;

            public synchronized float[] getQuick(int n4, int n22, int n32) {
                return this.content.getQuick(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void setQuick(int n4, int n22, int n32, float[] fArray) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, fArray);
            }

            public synchronized void setQuick(int n4, int n22, int n32, float f, float f2) {
                this.content.setQuick(n * n4, n2 * n22, n3 * n32, f, f2);
            }

            public synchronized float[] get(int n4, int n22, int n32) {
                return this.content.get(n * n4, n2 * n22, n3 * n32);
            }

            public synchronized void set(int n4, int n22, int n32, float[] fArray) {
                this.content.set(n * n4, n2 * n22, n3 * n32, fArray);
            }

            public synchronized void set(int n4, int n22, int n32, float f, float f2) {
                this.content.set(n * n4, n2 * n22, n3 * n32, f, f2);
            }
        };
        if (this.slices != 0) {
            wrapperFComplexMatrix3D.slices = (this.slices - 1) / n + 1;
        }
        if (this.rows != 0) {
            wrapperFComplexMatrix3D.rows = (this.rows - 1) / n2 + 1;
        }
        if (this.columns != 0) {
            wrapperFComplexMatrix3D.columns = (this.columns - 1) / n3 + 1;
        }
        wrapperFComplexMatrix3D.isNoView = false;
        return wrapperFComplexMatrix3D;
    }

    protected FComplexMatrix3D getContent() {
        return this.content;
    }

    public FComplexMatrix2D like2D(int n, int n2) {
        throw new InternalError();
    }

    protected FComplexMatrix2D like2D(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new InternalError();
    }

    protected FComplexMatrix3D viewSelectionLike(int[] nArray, int[] nArray2, int[] nArray3) {
        throw new InternalError();
    }

    public FloatMatrix3D getImaginaryPart() {
        final DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = new DenseLargeFloatMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperFComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < WrapperFComplexMatrix3D.this.columns; ++k) {
                                    denseLargeFloatMatrix3D.setQuick(i, j, k, WrapperFComplexMatrix3D.this.getQuick(i, j, k)[1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        denseLargeFloatMatrix3D.setQuick(i, j, k, this.getQuick(i, j, k)[1]);
                    }
                }
            }
        }
        return denseLargeFloatMatrix3D;
    }

    public FloatMatrix3D getRealPart() {
        final DenseLargeFloatMatrix3D denseLargeFloatMatrix3D = new DenseLargeFloatMatrix3D(this.slices, this.rows, this.columns);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < WrapperFComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < WrapperFComplexMatrix3D.this.columns; ++k) {
                                    denseLargeFloatMatrix3D.setQuick(i, j, k, WrapperFComplexMatrix3D.this.getQuick(i, j, k)[0]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        denseLargeFloatMatrix3D.setQuick(i, j, k, this.getQuick(i, j, k)[0]);
                    }
                }
            }
        }
        return denseLargeFloatMatrix3D;
    }
}

