% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_country_info_idn.R
\name{get_country_info_idn}
\alias{get_country_info_idn}
\title{Get Key Country Information About Indonesia from the REST Countries API}
\source{
REST Countries API: \url{https://restcountries.com/}
}
\usage{
get_country_info_idn()
}
\value{
A tibble with the following 8 columns:
\itemize{
  \item \code{name_common}: Common name of the country.
  \item \code{name_official}: Official name of the country.
  \item \code{region}: Geographical region.
  \item \code{subregion}: Subregion within the continent.
  \item \code{capital}: Capital city.
  \item \code{area}: Area in square kilometers.
  \item \code{population}: Population of the country.
  \item \code{languages}: Languages spoken in the country, as a comma-separated string.
}
Returns \code{NULL} if the API is unavailable or returns an error.
}
\description{
Retrieves selected, essential information about Indonesia using the REST Countries API.
The function returns a tibble with core details such as population, area, capital, region,
and official language(s).

See the API documentation at \url{https://restcountries.com/}.
Example API usage: \url{https://restcountries.com/v3.1/name/indonesia?fullText=true}.
}
\details{
The function sends a GET request to the REST Countries API. If the API returns data for Indonesia,
the function extracts and returns selected fields as a tibble. If the request fails or
Indonesia is not found, it returns \code{NULL} and prints a message.
}
\note{
Requires internet connection. The data is retrieved in real time from the REST Countries API.
}
\examples{
\donttest{
get_country_info_idn()
}

}
