% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_indonesia_unemployment.R
\name{get_indonesia_unemployment}
\alias{get_indonesia_unemployment}
\title{Get Indonesia's Unemployment Rate from World Bank}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SL.UEM.TOTL.ZS}
}
\usage{
get_indonesia_unemployment()
}
\value{
A tibble with:
\itemize{
  \item \code{indicator}: Indicator name.
  \item \code{country}: Country name ("Indonesia").
  \item \code{year}: Year (integer).
  \item \code{value}: Unemployment rate (numeric).
  \item \code{value_label}: Formatted unemployment rate (e.g., "5.2%").
}
Returns \code{NULL} if API request fails or data is unavailable.
}
\description{
Retrieves Indonesia's Unemployment, total (% of total labor force)
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SL.UEM.TOTL.ZS}.
}
\details{
If the API request fails for any reason (network issue, timeout,
invalid HTTP status, or malformed JSON), the function returns \code{NULL}
with an informative message.
}
\note{
Requires internet connection.
}
\examples{
\donttest{
get_indonesia_unemployment()
}

}
