% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_interaction_3way_r2.R
\name{power_interaction_3way_r2}
\alias{power_interaction_3way_r2}
\title{Analytic power analysis for 3-way interactions}
\usage{
power_interaction_3way_r2(
  N,
  b.x1x2x3,
  r.x1.y,
  r.x2.y,
  r.x3.y,
  r.x1x2.y,
  r.x1x3.y,
  r.x2x3.y,
  r.x1.x2,
  r.x1.x3,
  r.x2.x3,
  rel.x1 = 1,
  rel.x2 = 1,
  rel.x3 = 1,
  rel.y = 1,
  alpha = 0.05,
  detailed_results = FALSE,
  cl = NULL
)
}
\arguments{
\item{N}{Sample size. Must be a positive integer. Has no default value. Can be a single value or a vector of values.}

\item{b.x1x2x3}{Regression coefficient of the 3-way interaction term x1x2x3. Should not be specified if \code{f2} is specified. Must be between -1 and 1. Default is NULL. Can be a single value or a vector of values.}

\item{r.x1.y}{Pearson's correlation between x1 and y. Must be between -1 and 1. Has no default value. Can be a single value or a vector of values.}

\item{r.x2.y}{Pearson's correlation between x2 and y. Must be between -1 and 1. Assumed to be the 'moderator' in some functions. Has no default value. Can be a single value or a vector of values.}

\item{r.x3.y}{Pearson's correlation between x3 and y. Must be between -1 and 1. Assumed to be the 'moderator' in some functions. Has no default value. Can be a single value or a vector of values.}

\item{r.x1x2.y}{Pearson's correlation between the interaction term x1x2 (x1 * x2) and y. Must be between -1 and 1. Has no default value. Can be a single value or a vector of values.}

\item{r.x1x3.y}{Pearson's correlation between the interaction term x1x2 (x1 * x3) and y. Must be between -1 and 1. Has no default value. Can be a single value or a vector of values.}

\item{r.x2x3.y}{Pearson's correlation between the interaction term x1x2 (x2 * x3) and y. Must be between -1 and 1. Has no default value. Can be a single value or a vector of values.}

\item{r.x1.x2}{Pearson's correlation between x1 and x2. Must be between -1 and 1. Has no default value. Can be a single value or a vector of values.}

\item{r.x1.x3}{Pearson's correlation between x1 and x3. Must be between -1 and 1. Has no default value. Can be a single value or a vector of values.}

\item{r.x2.x3}{Pearson's correlation between x2 and x3. Must be between -1 and 1. Has no default value. Can be a single value or a vector of values.}

\item{rel.x1}{Reliability of x1 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.x2}{Reliability of x2 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.x3}{Reliability of x3 (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{rel.y}{Reliability of xy (e.g. test-retest reliability, ICC, Cronbach's alpha). Default is 1 (perfect reliability). Must be greater than 0 and less than or equal to 1.}

\item{alpha}{The alpha. At what p-value is the interaction deemed significant? Default is 0.05.}

\item{detailed_results}{Default is FALSE. Should detailed results be reported? Returns regression slopes, f2, r2, and the full correlation matrix.}

\item{cl}{Number of clusters to use for running simulations in parallel. Default is NULL (i.e. not in parallel). Useful when running several thousand analyses at once.}
}
\value{
A data frame containing the power for each unique setting combination.
}
\description{
Power analysis for 3-way interaction models, computed via change in R2. Valid for interactions with continuous, normally distributed, variables. Either \code{b.x1x2x3} or \code{f2} can be used to specify the magnitude of the interaction effect size.
}
\examples{
power_interaction_3way_r2(N=1000,r.x1.y = .1,r.x2.y = .2,r.x3.y = .3,
r.x1x2.y =  .05,r.x1x3.y =  .07,r.x2x3.y =  .09,b.x1x2x3 =0.01,
r.x1.x2 = .2,r.x1.x3 = .4,r.x2.x3 = .3)

}
