% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{buildStabilityTable}
\alias{buildStabilityTable}
\title{Finds how many iterations are necessary to achieve stability in resampling method.}
\usage{
buildStabilityTable(data, times = 10, samples = 100, plots = TRUE,
  scalingUpTo = "Quantile")
}
\arguments{
\item{data}{data structure after loading the file using \code{loadFile} function}

\item{times}{the number of times \code{rescaleI} will be executed. The default value is 100.}

\item{samples}{size of the resampling method. The default value is 1000}

\item{plots}{to draw the significance plot}

\item{scalingUpTo}{the rescaling could be done up to the 0.01\% and 99.99\% quantile or max and min values. The two possible options are: "MaxMin", or "Quantile". The default value for this parameter is "Quantile"}
}
\value{
A vector with the average \eqn{\log(samples)} averages I
}
\description{
\code{buildStabilityTable}  finds how many iterations are necessary to achieve stability in resampling method, plotting in a log scale.
}
\examples{
fileInput <- system.file("testdata", "chen.csv", package="Irescale")
data <- loadFile(fileInput)
resultsChen<-buildStabilityTable(data=data,times=10,samples=100,plots=TRUE,scalingUpTo="Quantile")
}
