% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives_helpers.R
\name{styletests}
\alias{styletests}
\alias{.styleaov}
\alias{.style2sttest}
\alias{.stylepairedttest}
\alias{.stylepairedwilcox}
\alias{.stylepairedmcnemar}
\alias{.stylekruskal}
\alias{.stylechisq}
\alias{.stylemsd}
\alias{.stylemdniqr}
\alias{.stylefreq}
\title{Several internal functions to style inference tests}
\usage{
.styleaov(dv, g, digits = 2L, pdigits = 3L)

.style2sttest(dv, g, digits = 2, pdigits = 3)

.stylepairedttest(dv, g, ID, digits = 2, pdigits = 3)

.stylepairedwilcox(dv, g, ID, digits = 2, pdigits = 3, ...)

.stylepairedmcnemar(dv, g, ID, digits = 2, pdigits = 3)

.stylekruskal(dv, g, digits = 2, pdigits = 3)

.stylechisq(dv, g, digits = 2, pdigits = 3, simChisq = FALSE, sims = 10000)

.stylemsd(n, x, digits = 2, includeLabel = FALSE)

.stylemdniqr(n, x, digits = 2, includeLabel = FALSE)

.stylefreq(n, x)
}
\arguments{
\item{dv}{An outcome variable}

\item{g}{A grouping/predictor variable}

\item{digits}{An integer indicating the number of significant digits to use.
Defaults to \code{2}.}

\item{pdigits}{An integer indicating the number of digits for p values.
Defaults to \code{3}.}

\item{...}{Additional arguments passed to \code{\link[stats]{wilcox.test}}.}

\item{simChisq}{A logical value, whether or not to simulate chi-square values.
Only applies to some functions. Defaults to \code{FALSE}.}

\item{sims}{An integer indicating the number of simulations to conduct.
Only applies to some functions. Defaults to \code{10000}, but this is
arbitrary and should be chosen.}
}
\value{
A character string of the formatted results.
}
\description{
Several internal functions to style inference tests
}
\examples{

JWileymisc:::.styleaov(mtcars$mpg, mtcars$cyl)

JWileymisc:::.style2sttest(mtcars$mpg, mtcars$am)

JWileymisc:::.stylepairedttest(sleep$extra, sleep$group, sleep$ID)

JWileymisc:::.stylepairedwilcox(sleep$extra, sleep$group, sleep$ID)

## example data
set.seed(1234)
exdata <- data.frame(
  ID = rep(1:10, 2),
  Time = rep(c("base", "post"), each = 10),
  Rating = sample(c("good", "bad"), size = 20, replace = TRUE))
JWileymisc:::.stylepairedmcnemar(exdata$Rating, exdata$Time, exdata$ID)
rm(exdata) ## cleanup

JWileymisc:::.stylekruskal(mtcars$mpg, mtcars$am)
JWileymisc:::.stylekruskal(mtcars$mpg, mtcars$cyl)

JWileymisc:::.stylechisq(mtcars$cyl, mtcars$am)

JWileymisc:::.stylemsd("Miles per Gallon", mtcars$mpg)
JWileymisc:::.stylemsd("Miles per Gallon", mtcars$mpg, includeLabel = TRUE)

JWileymisc:::.stylemdniqr("Miles per Gallon", mtcars$mpg)
JWileymisc:::.stylemdniqr("Miles per Gallon", mtcars$mpg, includeLabel = TRUE)

JWileymisc:::.stylefreq("Transmission", mtcars$am)
JWileymisc:::.stylefreq("Transmission", mtcars$am)
}
\keyword{internal}
