% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSD.R
\name{KSD}
\alias{KSD}
\title{Estimate Kernelized Stein Discrepancy (KSD)}
\usage{
KSD(x, score_function, kernel = "rbf", width = -1, nboot = 1000)
}
\arguments{
\item{x}{Sample of size Num_Instance x Num_Dimension}

\item{score_function}{(\eqn{\nabla_x \log p(x)}) Score funtion : takes x as input and
output a column vector of size Num_Instance X Dimension.
User may use pryr package to pass in a function that only takes in dataset as parameter,
or user may also pass in computed score for a given dataset.}

\item{kernel}{Type of kernel (default = 'rbf')}

\item{width}{Bandwidth of the kernel
(when width = -1 or 'median', set it to be the median distance between data points)}

\item{nboot}{Bootstrap sample size}
}
\value{
A list which includes the following variables :
\itemize{
\item "ksd" : Estimated Kernelized Stein Discrepancy (KSD)
\item "p" :  p-Value for rejecting the null hypothesis that ksd = 0
\item "bootstrapSamples" :  the bootstrap sample
\item "info":   other information, including :
bandwidth, M, nboot, ksd_V
}
}
\description{
Estimate kernelized Stein discrepancy (KSD) using U-statistics,
and use bootstrap to test H0: \eqn{x_i} is drawn from \eqn{p(X)} (via KSD=0).
}
\examples{
# Pass in a dataset generated by Gaussian distribution,
# use pryr package to pass in score function
model <- gmm()
X <- rgmm(model, n=100)
score_function = pryr::partial(scorefunctiongmm, model=model)
result <- KSD(X,score_function=score_function)

# Pass in a dataset generated by Gaussian distribution,
# pass in computed score rather than score function
model <- gmm()
X <- rgmm(model, n=100)
score_function = scorefunctiongmm(model=model, X=X)
result <- KSD(X,score_function=score_function)

# Pass in a dataset generated by Gaussian distribution,
# pass in computed score rather than score function
# Use median_heuristic by specifying width to be -2.0
model <- gmm()
X <- rgmm(model, n=100)
score_function = pryr::partial(scorefunctiongmm, model=model)
result <- KSD(X,score_function=score_function, 'rbf',-2.0)

# Pass in a dataset generated by specific Gaussian distribution,
# pass in computed score rather than score function
# Use median_heuristic by specifying width to be -2.0
model <- gmm()
X <- rgmm(model, n=100)
score_function = pryr::partial(scorefunctiongmm, model=model)
result <- KSD(X,score_function=score_function, 'rbf',-2.0)
}
