% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_preprocessing.R
\name{extract_topics}
\alias{extract_topics}
\title{Apply topic modeling to a corpus}
\usage{
extract_topics(
  text_data,
  text_column = "abstract",
  n_topics = 5,
  max_terms = 10,
  n_iterations = 50,
  seed = NULL
)
}
\arguments{
\item{text_data}{A data frame containing the text data}

\item{text_column}{Name of the column containing the text}

\item{n_topics}{Number of topics to extract}

\item{max_terms}{Maximum number of terms per topic to return}

\item{n_iterations}{Number of iterations for the NMF algorithm}

\item{seed}{Optional seed for reproducibility. If NULL, no seed is set.}
}
\value{
A list containing topic-term and document-topic matrices
}
\description{
This function implements a simple non-negative matrix factorization (NMF)
approach to topic modeling, without requiring additional packages.
}
