% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_model.R
\name{validate_abc}
\alias{validate_abc}
\title{Apply statistical validation to ABC model results with support for large matrices}
\usage{
validate_abc(
  abc_results,
  co_matrix,
  alpha = 0.05,
  correction = c("BH", "bonferroni", "none"),
  filter_by_significance = FALSE
)
}
\arguments{
\item{abc_results}{A data frame containing ABC results.}

\item{co_matrix}{The co-occurrence matrix used to generate the ABC results.}

\item{alpha}{Significance level (p-value threshold).}

\item{correction}{Method for multiple testing correction.}

\item{filter_by_significance}{Logical. If TRUE, only returns significant results.}
}
\value{
A data frame with ABC results and statistical significance measures.
}
\description{
This function performs statistical tests to validate ABC model results.
It calculates p-values using hypergeometric tests and applies correction for multiple testing.
The function is optimized to work with very large co-occurrence matrices.
}
