% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{vis_heatmap}
\alias{vis_heatmap}
\title{Create an enhanced heatmap of ABC connections}
\usage{
vis_heatmap(
  abc_results,
  top_n = 25,
  min_score = 0.1,
  show_significance = TRUE,
  color_palette = "blues",
  title = "ABC Connections Heatmap",
  show_entity_types = TRUE
)
}
\arguments{
\item{abc_results}{A data frame containing ABC results.}

\item{top_n}{Number of top results to visualize.}

\item{min_score}{Minimum score threshold for including connections.}

\item{show_significance}{Logical. If TRUE, marks significant connections.}

\item{color_palette}{Character. Color palette to use for the heatmap.}

\item{title}{Plot title.}

\item{show_entity_types}{Logical. If TRUE, includes entity types in axis labels.}
}
\value{
NULL invisibly. The function creates a plot as a side effect.
}
\description{
This function creates an improved heatmap visualization of ABC connections
that can display entity type information when available, without enforcing
type constraints.
}
