% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_SC_MERGE.R
\name{sc.merge}
\alias{sc.merge}
\title{Special case merging procedure}
\usage{
sc.merge(x, y, sc = "SC", sc.merge = "closest", force.trend = "modalities")
}
\arguments{
\item{x}{Categorical risk factor.}

\item{y}{Target variable.}

\item{sc}{Vector of special case values. Default is set to \code{"SC"}.}

\item{sc.merge}{Merging method. Available options are: \code{"first"}, \code{"last"} and \code{"closest"}.
Default value is \code{"closest"} and it is determined as the bin with the closest average target rate.}

\item{force.trend}{Defines how initial summary table will be ordered. Possible options are:\cr
\code{"modalities"} and \code{"y.avg"}. If  \code{"modalities"} is selected, then merging will be
performed forward based on alphabetic order of risk factor modalities. On the other hand,
if \code{"y.avg"} is selected, then bins merging will be performed forward based on increasing order of
mean of target variable per modality.}
}
\value{
The command \code{sc.merge} generates a list of two objects. The first object, data frame \code{summary.tbl}
presents a summary table of final binning, while \code{x.trans} is a vector of recoded values.
}
\description{
\code{sc.merge} performs procedure of merging special case bins with one from complete cases.
This procedure can be used not only for LGD model development, but also for PD and EAD, i.e. for
all models that have categorical risk factors.
}
\examples{
library(monobin)
library(LGDtoolkit)
data(lgd.ds.c)
rf.03.bin.s <- sts.bin(x = lgd.ds.c$rf_03, y = lgd.ds.c$lgd)
rf.03.bin.s[[1]]
table(rf.03.bin.s[[2]])
lgd.ds.c$rf_03_bin <- rf.03.bin.s[[2]]
rf.03.bin.c <- sc.merge(x = lgd.ds.c$rf_03_bin, 
			y = lgd.ds.c$lgd, 
			sc = "SC", 
			sc.merge = "closest", 
			force.trend = "modalities")
str(rf.03.bin.c)
rf.03.bin.c[[1]]
table(rf.03.bin.c[[2]])
}
