% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmlx.R
\name{buildmlx}
\alias{buildmlx}
\title{buildmlx: Automatic statistical model building}
\usage{
buildmlx(
  project = NULL,
  final.project = NULL,
  model = "all",
  prior = NULL,
  weight = NULL,
  coef.w1 = 0.5,
  paramToUse = "all",
  covToTest = "all",
  covToTransform = "none",
  center.covariate = FALSE,
  criterion = "BICc",
  linearization = FALSE,
  ll = TRUE,
  test = FALSE,
  direction = NULL,
  steps = 1000,
  n.full = 10,
  max.iter = 20,
  explor.iter = 2,
  fError.min = 0.001,
  seq.cov = FALSE,
  seq.cov.iter = 0,
  seq.corr = TRUE,
  p.max = if (buildMethod == "stepAIC") {
     0.1
 } else {
     1
 },
  p.min = c(0.075, 0.05, 0.1),
  print = TRUE,
  nb.model = 1,
  nfolds = 5,
  alpha = 1,
  nSS = 1000,
  buildMethod = "lasso",
  FDR_thr = 0.1
)
}
\arguments{
\item{project}{a string: the initial Monolix project}

\item{final.project}{a  string: the final Monolix project (default adds "_built" to the original project)}

\item{model}{components of the model to optimize c("residualError", "covariate", "correlation"), (default="all")}

\item{prior}{list of prior probabilities for each component of the model (default=NULL)}

\item{weight}{list of penalty weights for each component of the model (default=NULL)}

\item{coef.w1}{multiplicative weight coefficient used for the first iteration only (default=0.5)}

\item{paramToUse}{list of parameters possibly function of covariates (default="all")}

\item{covToTest}{components of the covariate model that can be modified (default="all")}

\item{covToTransform}{list of (continuous) covariates to be log-transformed (default="none")}

\item{center.covariate}{TRUE/FALSE center the covariates of the final model (default=FALSE)}

\item{criterion}{penalization criterion to optimize c("AIC", "BIC", "BICc", gamma) (default=BICc)}

\item{linearization}{TRUE/FALSE whether the computation of the likelihood is based on a linearization of the model (default=FALSE)}

\item{ll}{TRUE/FALSE compute the observe likelihood and the criterion to optimize at each iteration}

\item{test}{TRUE/FALSE perform additional statistical tests for building the model (default=FALSE)}

\item{direction}{for stepAIC method, method for covariate search c("full", "both", "backward", "forward"), (default="full" or "both")}

\item{steps}{for stepAIC method, maximum number of iteration for stepAIC (default=1000)}

\item{n.full}{for stepAIC method, maximum number of covariates for an exhaustive comparison of all possible covariate models (default=10)}

\item{max.iter}{maximum number of iterations (default=20)}

\item{explor.iter}{number of iterations during the exploratory phase (default=2)}

\item{fError.min}{minimum fraction of residual variance for combined error model (default = 1e-3)}

\item{seq.cov}{TRUE/FALSE whether the covariate model is built before the correlation model}

\item{seq.cov.iter}{number of iterations before building the correlation model (only when seq.cov=F, default=0)}

\item{seq.corr}{TRUE/FALSE whether the correlation model is built iteratively (default=TRUE)}

\item{p.max}{maximum p-value used for removing non significant relationships between covariates and individual parameters (default=0.1 for stepAIC and 1 for lasso)}

\item{p.min}{vector of 3 minimum p-values used for testing the components of a new model (default=c(0.075, 0.05, 0.1))}

\item{print}{TRUE/FALSE display the results (default=TRUE)}

\item{nb.model}{number of models to display at each iteration (default=1)}

\item{nfolds}{for lasso method, number of folds (default=10)}

\item{alpha}{for lasso method, the elasticnet mixing parameter, between 0 and 1. \code{alpha=1} is the lasso penalty, \code{alpha=0} is the ridge penalty.}

\item{nSS}{for lasso method, number of resampling iterations for stability selection.}

\item{buildMethod}{the method used to build the covariate model (default="lasso")}

\item{FDR_thr}{for lasso method, upper-bounds in FDP of calibrated stability selection (default=0.1)}
}
\value{
a new Monolix project with a new statistical model.
}
\description{
buildmlx uses SAMBA (Stochastic Approximation for Model Building Algorithm), an iterative procedure to accelerate and optimize the process of model building by identifying at each step how best to improve some of the model components. This method allows to find the optimal statistical model which minimizes some information criterion in very few steps.
}
\details{
For covariates model building, covariate selection can be achieved by stepAIC, as the original SAMBA algorithm was implemented in Rsmlx package (Prague and Lavielle, 2020  ; Mihaljevic, 2023) and by a lasso approach enhanced by stability selection (Bodinier et al., 2023).
}
\examples{
\dontrun{
project <- getMLXdir()

res = buildmlx(project = project,
               buildMethod = "lasso",
               model='covariate',
               test=FALSE)

getIndividualParameterModel()
}
}
\references{
Prague M, Lavielle M.  SAMBA: A novel method for fast automatic model building in nonlinear mixed-effects models.  CPT Pharmacometrics Syst Pharmacol. 2022; 11: 161-172. doi:10.1002/psp4.12742

Bodinier B, Filippi S, Haugdahl Nøst T, Chiquet J, Chadeau-Hyam M. Automated calibration for stability selection in penalised regression and graphical models. Journal of the Royal Statistical Society Series C: Applied Statistics. 2023 ; 72: 1375–1393. doi:10.1093/jrsssc/qlad058

Mihaljevic F (2023).  Rsmlx: R Speaks 'Monolix'. R package version2023.1.5, \url{https://CRAN.R-project.org/package=Rsmlx}.
}
