% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LandComp.R
\encoding{UTF-8}
\name{LandComp}
\alias{LandComp}
\title{LandComp: quantify landscape diversity and structure}
\usage{
LandComp(
  x,
  aggregation_steps = c(0, 1, 1.5, 2:5),
  parallelrun = TRUE,
  savememory = FALSE,
  precision = 4
)
}
\arguments{
\item{x}{An \code{sf} object of type \code{POLYGON} that must have projected coordinates
(i.e. WGS-84 is not accepted). Geometry must be a regular spatial grid
containing either squares or hexagons. Both flat topped and pointy topped
hexagons are accepted. Fields should contain binary integer values (i.e., 0s
and 1s). Logical values are coerced with warning.}

\item{aggregation_steps}{A numeric vector containing non-negative numbers. The
vector elements express the size of the spatial units for which calculation
of compositional diversity and associatum is required. The size is measured
by the number of rows of grid cells around the central grid cell, where 0
means the original grid cell without enlargement. Analysis can be done more
precise by giving also fraction numbers as input. In this case, the
following step's spatial unit minus grid cells touching the vertices are
used as spatial base units. Note, in the case of hexagonal grid, steps
falling in the interval ]0,1[ cannot be evaluated. Negative, non-finite and
missing values are ignored with warning.}

\item{parallelrun}{A logical vector of length one indicating whether
aggregation should be performed in a parallel way (defaults to \code{TRUE}). All
available processor cores are used in the case of parallel processing.
Should be set to \code{FALSE} if memory limitation occurs.}

\item{savememory}{A logical vector of length one indicating whether a slower
but less memory-demanding algorithm should run (defaults to \code{FALSE}). Should
be set to \code{TRUE} if the available memory is limited.}

\item{precision}{A numeric vector of length one. Number of digits to which the
areas of grid cells are rounded. Should be decreased if the grid is not
perfectly regular and the equality check of the grid cells' area fails.}
}
\value{
A \code{data.frame} of \code{length(aggregation_steps)} rows with the following
columns and attribute:
\itemize{
\item \strong{AggregationStep}: size of the spatial units measured by
the number of rows of grid cells around the central grid cell. The content
(and order) of this column is the same as the parameter
\code{aggregation_steps} except that negative, non-finite and missing values
are removed. It also serves as an ID in the resulting \code{data.frame}.
\item \strong{SpatialUnit_Size}: number of grid cells contained by the aggregated,
large unit.
\item \strong{SpatialUnit_Area}: area of the aggregated, large unit
\item \strong{SpatialUnit_Count}: sample size.
\item \strong{UniqueCombination_Count}: number of unique landscape class combinations.
\item \strong{CD_bit}: compositional diversity (sensu Juhász-Nagy) of \code{x}.
\item \strong{AS_bit}: associatum (sensu Juhász-Nagy) of  \code{x}
\item \strong{attr(*, "unit")}: unit of the CRS of the object provided to \code{x}.
}
}
\description{
Calculate compositional diversity and associatum of landscape data at
different spatial scales.
}
\details{
The function is based on the model family created by Juhász-Nagy
(1976, 1984, 1993). Compositional diversity
(\ifelse{html}{\out{CD}}{\eqn{CD}}) measures the diversity of landscape
class combinations. Associatum (\ifelse{html}{\out{AS}}{\eqn{AS}})
characterizes the spatial dependence of landscape classes. It is measured as
the difference of the "random" diversity (i.e. predicted diversity with the
assumption of independent occurrence of landscape classes) and the observed
diversity. Both functions have typically one maximum
(\ifelse{html}{\out{CD<sub>max</sub>}}{\eqn{CD_{max}}},
\ifelse{html}{\out{AS<sub>max</sub>}}{\eqn{AS_{max}}}), when plotting
against increasing scale. Unit sizes corresponding to the maxima values of
both functions (\ifelse{html}{\out{A<sub>CD</sub>}}{\eqn{A_{CD}}},
\ifelse{html}{\out{A<sub>CD</sub>}}{\eqn{A_{AS}}}) help to capture the
spatial scale holding the most information. These indices, particularly
\ifelse{html}{\out{CD<sub>max</sub>}}{\eqn{CD_{max}}},
\ifelse{html}{\out{AS<sub>max</sub>}}{\eqn{AS_{max}}} and
\ifelse{html}{\out{A<sub>CD</sub>}}{\eqn{A_{CD}}} can be effectively used as
indicators (Juhász-Nagy & Podani 1983). Though the functions were originally
applied in community ecology, the current function supports their
application in the landscape context (see also Konrád et al. 2023).
}
\examples{
data(square_data)
LandComp(x = square_data, aggregation_steps = 0)

\donttest{
LandComp(x = square_data, aggregation_steps = 0, parallelrun = FALSE)
LandComp(x = square_data, aggregation_steps = c(0.5, 1, 1.5))

data(hexagonal_data)
LandComp(x = hexagonal_data, aggregation_steps = c(0, 1, 1.5))
}

}
\references{
\itemize{
\item Juhász-Nagy P (1976) Spatial dependence of plant populations. Part 1.
Equivalence analysis (An outline of new model). \emph{Acta Bot Acad Sci Hung 22}:
61–78.
\item Juhász-Nagy P (1984) Spatial dependence of plant population. 2. A family
of new models. \emph{Acta Bot Hung 30}: 363–402.
\item Juhász-Nagy P (1993) Notes on compositional diversity. \emph{Hydrobiologia 249}:
173–182.
\item Juhász-Nagy P, Podani J (1983) Information theory methods for the study of
spatial processes and succession. \emph{Vegetatio 51}: 129–140.
\item Konrád KD, Bede-Fazekas Á, Bartha S, Somodi I (2023) Adapting a multiscale
approach to assess the compositional diversity of landscapes. \emph{Landsc Ecol}
\emph{38}: 2731–2747.
}
}
\concept{Juhász-Nagy's functions}
\concept{landscape diversity}
\concept{multilayer analysis}
