% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SSB.R
\name{get_SSB}
\alias{get_SSB}
\alias{get_SSB,LeMans_param,LeMans_outputs-method}
\alias{get_SSB,LeMans_param,missing-method}
\alias{get_SSB,missing,LeMans_outputs-method}
\alias{get_SSB,missing,missing-method}
\alias{get_biomass}
\alias{get_biomass,LeMans_param,LeMans_outputs-method}
\alias{get_biomass,LeMans_param,missing-method}
\alias{get_biomass,missing,LeMans_outputs-method}
\alias{get_biomass,missing,missing-method}
\title{Calculate Spawning Stock Biomass (SSB) or total biomass}
\usage{
get_SSB(inputs, outputs, ...)

\S4method{get_SSB}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3]
)

\S4method{get_SSB}{LeMans_param,missing}(inputs, N, species = 1:dim(N)[2], time_steps = 1:dim(N)[3])

\S4method{get_SSB}{missing,LeMans_outputs}(
  wgt,
  mature,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  species_names = NULL
)

\S4method{get_SSB}{missing,missing}(
  wgt,
  mature,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  species_names = NULL
)

get_biomass(inputs, outputs, ...)

\S4method{get_biomass}{LeMans_param,LeMans_outputs}(
  inputs,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3]
)

\S4method{get_biomass}{LeMans_param,missing}(inputs, N, species = 1:dim(N)[2], time_steps = 1:dim(N)[3])

\S4method{get_biomass}{missing,LeMans_outputs}(
  wgt,
  outputs,
  species = 1:dim(outputs@N)[2],
  time_steps = 1:dim(outputs@N)[3],
  species_names = NULL
)

\S4method{get_biomass}{missing,missing}(
  wgt,
  N,
  species = 1:dim(N)[2],
  time_steps = 1:dim(N)[3],
  species_names = NULL
)
}
\arguments{
\item{inputs}{A \linkS4class{LeMans_param} object containing the parameter values of the current LeMans model.}

\item{outputs}{A \linkS4class{LeMans_outputs} object containing the outputs of the model run.}

\item{...}{Additional arguments.}

\item{species}{A numeric value or vector or a character string or vector of the species that you wish to calculate the mean maximum length. The default is \code{1:dim(N)[2]}.}

\item{time_steps}{A numeric vector of the time steps that you wish to calculate the mean maximum length. The default is \code{1:dim(N)[3]}.}

\item{N}{An array with dimensions \code{nsc}, \code{nfish} and \code{tot_time} representing the number of individuals in each length class for each time step.}

\item{wgt}{A matrix with dimensions \code{nsc} and \code{nfish} representing the weight of each species in each length class.}

\item{mature}{A matrix with dimensions \code{ncs} and \code{nfish} with elements in the range 0-1 representing the proportion of mature individuals of each species in each length class.}

\item{species_names}{A character vector of length \code{nfish} that denotes the names of the species in the model.}
}
\value{
If \code{length(species)>1}, \code{get_SSB} returns a matrix with dimensions \code{length(time_steps)} by \code{length(species)} where the \code{i,j}th element is the SSB (g) of the \code{j}th \code{species} in the \code{i}th \code{time_steps}. If \code{length(species)==1}, the function will return a numeric vector of length \code{length(time_steps)}.

If \code{length(species)>1}, \code{get_biomass} returns a matrix with dimensions \code{length(time_steps)} by \code{length(species)} where the \code{i,j}th element is the biomass (g) of the \code{j}th \code{species} in the \code{i}th \code{time_steps}. If \code{length(species)==1}, the function will return a numeric vector of length \code{length(time_steps)}.
}
\description{
Calculates the Spawning Stock Biomass (SSB) or the total biomass of each species in the model.
}
\details{
The SSB for each species in \code{species} is equal to:

\code{colSums(N[, species]*wgt[, species]*mature[, species])}.

The biomass for each species in \code{species} is equal to:

\code{colSums(N[, species]*wgt[, species])}
}
\examples{
# Set up and run the model
NS_params <- LeMansParam(NS_par, tau=NS_tau, eta=rep(0.25, 21), L50=NS_par$Lmat, other=1e12)
effort <- matrix(0.5, 10, dim(NS_params@Qs)[3])
model_run <- run_LeMans(NS_params, years=10, effort=effort)

# Calculate SSB
get_SSB(inputs=NS_params, outputs=model_run)

# Calculate biomass
get_biomass(inputs=NS_params, outputs=model_run)
}
