% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AproxBinomNorm.R
\name{AproxBinomNorm}
\alias{AproxBinomNorm}
\title{Illustration of the Normal approximation to Binomial}
\usage{
AproxBinomNorm(n, p, legend = TRUE, xlab = "", ylab = "Probability",
  main = "Normal approximation to Binomial", col.fill = "grey",
  col.line = "red", lwd = 2)
}
\arguments{
\item{n}{number of independent Bernouilli trials.}

\item{p}{probability of success associated with the Bernouilli trial.}

\item{legend}{logical argument indicating whether to display the legend on the plot or not, default to TRUE.}

\item{xlab}{x-axis label; default to empty.}

\item{ylab}{y-axis label; default to "Probability."}

\item{main}{title; default to "Normal approximation to Binomial".}

\item{col.fill}{colour to fill-in the bars; default to grey.}

\item{col.line}{colour to draw the line of the Normal density; default to red.}

\item{lwd}{line width for the Normal density, a positive number; default to 2.}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
When certain conditions are met (see Details), the Binomial distribution can be approximated by the Normal one. The function \code{AproxBinomNorm} illustrates this fact by plotting the mass diagram corresponding with the discrete distribution (parameters are given by the user) on which the associated Normal density function is also displayed.
}
\details{
The approximation is accurate only if one of these three conditions is met:

- p in (0.1, 0.9) and n>=30,

- p in [0,0.1] and np>5,

- p in [0.9,1] and n(1-p)>5.
}
\examples{
n=45; p=0.4
AproxBinomNorm(n,p)
AproxBinomNorm(n,p,col.fill="blue",col.line="orange")
AproxBinomNorm(n,p,legend=FALSE)

}
