% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Histogram.R
\name{Histogram}
\alias{Histogram}
\title{Plot a Histogram}
\usage{
Histogram(x, freq = FALSE, col.fill = "grey", main = "autom",
  xlab = "", ylab = "autoy")
}
\arguments{
\item{x}{a numeric vector containing the sample provided to compute the histogram.}

\item{freq}{a single logical value; if TRUE, the histogram graphic uses absolute frequencies; if FALSE (default), a histogram of area 1 (density) is plotted.}

\item{col.fill}{a single colour to be used to fill the bars; default to grey.}

\item{main}{main title, by default "Histogram" or "Histogram of area 1" depending on the value of the argument freq, TRUE or FALSE respectively.}

\item{xlab}{x-axis label; by default empty.}

\item{ylab}{y-axis label; by default "Frequency" or "Density" depending on the value of the argument freq, TRUE or FALSE respectively.}
}
\value{
A list containing the following components:
\item{ni}{a numeric vector containing the absolute frequencies.}
\item{fi}{a numeric vector containing the relative frequencies.}
\item{Ni}{a numeric vector containing the absolute cumulative frequencies.}
\item{Fi}{a numeric vector containing the relative cumulative frequencies.}
\item{tab}{the frequency table.}
Independently on the user saving those values, the function provides the frequency table on the console.
}
\description{
The function \code{Histogram} plots a histogram of a given sample.
}
\details{
The procedure to construct the histogram is detailed below:

   - number of intervals: the closest integer to sqrt(n);

   - amplitude of each interval: the range of the sample divided by the number of intervals, i.e., the breaks are equidistant and rounded to two decimals;

   - height of each bar: by default (freq=FALSE) the plotted histogram is a density (area 1); if freq=TRUE, then the values of the bars are the absolute frequencies.
}
\examples{
x=rnorm(10)
Histogram(x)
Histogram(x,freq=TRUE)
Histogram(x,freq=TRUE,col="pink")

}
