% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffmean.CI.R
\name{diffmean.CI}
\alias{diffmean.CI}
\title{Confidence Interval for the Difference between the Means of Two Normal Populations.}
\usage{
diffmean.CI(x1, x2, sigma1 = NULL, sigma2 = NULL, sc1 = NULL,
  sc2 = NULL, s1 = NULL, s2 = NULL, n1 = NULL, n2 = NULL,
  paired = FALSE, var.equal = FALSE, conf.level)
}
\arguments{
\item{x1}{numeric vector or value corresponding with either one of the samples or the sample mean.}

\item{x2}{numeric vector or value corresponding with either one of the samples or the sample mean.}

\item{sigma1}{if known, a single numeric value corresponding with one of the population standard deviation.}

\item{sigma2}{if known, a single numeric value corresponding with the other population standard deviation.}

\item{sc1}{a single numeric value corresponding with the cuasi-standard deviation of one sample.}

\item{sc2}{a single numeric value corresponding with the cuasi-standard deviation of the other sample.}

\item{s1}{a single numeric value corresponding with the standard deviation of one sample.}

\item{s2}{a single numeric value corresponding with the standard deviation of the other sample.}

\item{n1}{a single positive integer value corresponding with the size of one sample; not needed if the sample is provided.}

\item{n2}{a single positive integer value corresponding with the size of the other sample; not needed if the sample is provided.}

\item{paired}{logical value indicating whether the populations are paired or independent; default to FALSE.}

\item{var.equal}{logical value indicating whether to treat the two variances as being equal. If TRUE then the pooled variance is used to estimate the variance, otherwise the Dixon and Massey approximation to the degrees of freedom is used; default to FALSE.}

\item{conf.level}{a single numeric value corresponding with the confidence level of the interval; must be a value in (0,1).}
}
\value{
A list containing the following components:
\item{estimate}{numeric value corresponding with the difference between the sample means.}
\item{CI}{a numeric vector of length two containing the lower and upper bounds of the confidence interval.}
Independently on the user saving those values, the function provides a summary of the result on the console.
}
\description{
\code{diffmean.CI} provides a pointwise estimation and a confidence interval for the difference between the means of two Normal populations in different scenarios: population variances known or unknown, population variances assumed equal or not, and paired or independent populations.
}
\details{
If sigma1 and sigma2 are given, known population variances formula is applied; the unknown one is used in other case.

If paired is TRUE then both x1 and x2 must be specified and their sample sizes must be the same. If paired is null, then it is assumed to be FALSE.

For var.equal=TRUE, the formula of the pooled variance is \eqn{\frac{(n1-1)sc1^2+(n2-1)sc2^2}{n1+n2-2}}.
}
\examples{
#Given unpaired samples with known population variance
dat1=rnorm(20,mean=2,sd=1);dat2=rnorm(30,mean=2,sd=1.5)
diffmean.CI(dat1,dat2,sigma1=1,sigma2=1.5,conf.level=0.9)

#Given unpaired samples with unknown but equal population variances
dat1=rnorm(20,mean=2,sd=1);dat2=rnorm(30,mean=2,sd=1)
diffmean.CI(dat1,dat2,paired=FALSE,var.equal=TRUE,conf.level=0.9)

#Given the characteristics of unpaired samples with unknown and different population variances
dat1=rnorm(20,mean=2,sd=1);dat2=rnorm(30,mean=2,sd=1)
x1=mean(dat1);x2=mean(dat2);sc1=sd(dat1);sc2=sd(dat2);n1=length(dat1);n2=length(dat2)
diffmean.CI(x1,x2,sc1=sc1,sc2=sc2,n1=n1,n2=n2,paired=FALSE,var.equal=FALSE,conf.level=0.9)

#Given paired samples
dat1=rnorm(20,mean=2,sd=1);dat2=dat1+rnorm(20,mean=0,sd=0.5)
diffmean.CI(dat1,dat2,paired=TRUE,conf.level=0.9)

}
