% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regresion.R
\name{plotReg}
\alias{plotReg}
\title{Representation of a Linear Regression Model}
\usage{
plotReg(x, y, main = "Linear Regression Model",
  xlab = "Explanatory variable (X)", ylab = "Response variable (Y)",
  col.points = "black", col.line = "red", pch = 19, lwd = 2,
  legend = TRUE)
}
\arguments{
\item{x}{a numeric vector that contains the values of the explanatory variable.}

\item{y}{a numeric vector that contains the values of the response variable.}

\item{main}{a main title for the plot; default to "Linear Regression Model".}

\item{xlab}{x-axis label; default to "Explanatory variable (X)".}

\item{ylab}{y-axis label; default to "Response variable (Y)".}

\item{col.points}{a single colour associated with the sample points; default to "black".}

\item{col.line}{a single colour associated with the fitted linear regression model; default to "red".}

\item{pch}{an integer specifying a symbol or a single character to be used as the default in plotting points; default to 19.}

\item{lwd}{line width for the estimated model, a positive number; default to 2.}

\item{legend}{logical value; if TRUE (default), a legend with details about fitted model is included.}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
Representation of a Linear Regression Model
}
\examples{
x=rnorm(100)
error=rnorm(100)
y=1+5*x+error
plotReg(x,y)
}
