% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinkedElements.R
\name{LinkedElements}
\alias{LinkedElements}
\title{Determines elements linked by loop anchors}
\usage{
LinkedElements(loop_ranges, element_ranges_x, element_ranges_y,
  range_out_x = FALSE, range_out_y = FALSE, overlap_threshold = 1)
}
\arguments{
\item{loop_ranges}{A single \emph{LoopRanges} object that has been subset to one range through ConsensusLoops().}

\item{element_ranges_x}{A subset \emph{ElementRanges} class object. Subset appropriate ranges by using list indexing.}

\item{element_ranges_y}{A subset \emph{ElementRanges} class object. Subset appropriate ranges by using list indexing.}

\item{range_out_x}{A boolean indicating if the output should be a subset element ranges object for element_ranges_x instead of the default dataframe. (default = FALSE)}

\item{range_out_y}{A boolean indicating if the output should be a subset element ranges object for element_ranges_y instead of the default dataframe. (default = FALSE)}

\item{overlap_threshold}{Single numerical input for significant base-pair overlap to be considered 'overlapping'. Default is 1 bp.}
}
\value{
Returns a dataframe indicating the unique element links present in the form of their first metadata columns. The element_ranges_x are always under column 1, and element_ranges_y are always under column 2.
}
\description{
Using a finalized \emph{LoopRanges} loops object and two sets of elements, determines which elements are linked by loops through overlap of anchor regions
}
\examples{
# Load enhancer and promoter elements into an ElementRanges object
enhancers <- system.file("extdata/elements", "enhancers.bed", package = "LoopRig", mustWork = TRUE)
promoters <- system.file("extdata/elements", "promoters.bed", package = "LoopRig", mustWork = TRUE)
element_ranges <- ElementsToRanges(enhancers, promoters, 
element_names = c("enhancers", "promoters"), 
custom_cols = 1, custom_mcols = 4)

# Load loops into LoopRanges object and determine consensus loops (keep all)
ovary_loops <- system.file("extdata/loops", "ovary_hg19.bedpe", 
package = "LoopRig", mustWork = TRUE)
pancreas_loops <- system.file("extdata/loops", "pancreas_hg19.bedpe", 
package = "LoopRig", mustWork = TRUE)
loops <- LoopsToRanges(ovary_loops, pancreas_loops, custom_cols = 0)
consensus_loops <- ConsensusLoops(loops, keep_all = TRUE)

# Based on consensus loops, determine which enhancers and promoters 
# are connected based on loop anchors 
LinkedElements(consensus_loops, element_ranges[[1]], element_ranges[[2]])  
}
