% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_alpha.R
\name{update_alpha}
\alias{update_alpha}
\title{the function to update alpha}
\usage{
update_alpha(WL, update_L_list, lambda)
}
\arguments{
\item{WL}{A list of similarity matrices}

\item{update_L_list}{A list with N+2 elements, the former N as modality private sub-matrices, the Nth as the shared sub-matrix and the last one as the current loss}

\item{lambda}{A parameter to set the relative weight of the group sparsity constraints}
}
\value{
A list containing the updated result in this iteration
}
\description{
update the sub-matrix alpha to convergence to its local minimum gradually
}
\examples{

WL <- simu_data_gen()
WL[[1]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[1]]),Standard_Normalization(WL[[1]])))
WL[[2]] <- affinityMatrix(dist2eu(Standard_Normalization(WL[[2]]),Standard_Normalization(WL[[2]])))
new_WL_list <- initialize_WL(WL)
k <- 5
lambda <- 0.25
init_list <- initialization(new_WL_list,k)
update_L_list <- update_L(new_WL_list,init_list)
update_alpha_list <- update_alpha(WL,update_L_list,lambda)
}
\author{
Xiaoyao Yin
}
