% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_matching.R
\name{check_matching}
\alias{check_matching}
\title{Check Whether the Variables are Balanced After Weighting}
\arguments{
\item{ipds_wts}{A data frame containing individual patient data from the
intervention study, with a column containing the estimated weights (derived
using \code{\link{estimate_weights}}).}

\item{agds}{A data frame containing aggregate summary data from the
comparator study.}

\item{summary.list}{A character list with two elements giving the names of
variables for summarizing: the first is a vector of binary variables, and
the second is a vector of continuous variables. The variable names must
match the column names in \emph{ipds} and do not need to be the same as those
in \emph{matching.list}. Use c() if a type is absent.}

\item{matching.list}{A character list with two elements giving the names of
variables for matching: the first is a vector of binary variables, and the
second is a vector of continuous variables. The variable names must match
the column names in \emph{ipds} and \emph{agds}. Use c() if a type is absent.}

\item{intervention.arm}{The name of the grouping column in the data frame
specified by \emph{ipds}, e.g., \code{intervention.arm = TRT}. The default is \code{TRT}.}

\item{comparator}{The name of the study column in the data frame specified
by \emph{agds}, e.g., \code{comparator = STUDY}. The default is \code{STUDY}.}

\item{comparator.study}{A character specifying the comparator study, which
must be quoted and cannot be empty (e.g., \code{comparator.study = "Study XX-1"}).
This is the value of the study column in \emph{agds} set by the \emph{comparator}
parameter.}

\item{comparator.arm}{The name of the grouping column in the data frame
specified by \emph{agds}, e.g., \code{comparator.arm = TRT}. The default is \code{TRT}.}

\item{comparator.n}{The name of the subjects number column in the data frame
specified by \emph{agds}, e.g., \code{comparator.n = N}. The default is \code{N}.}

\item{wt.col}{The name of the estimated weights column in the data frame
specified by \emph{ipds_wts}. The default is \code{wt}.}
}
\value{
A data frame containing all specified variables summarised before
and after weighting.
}
\description{
Check Whether the Variables are Balanced After Weighting
}
\examples{
\donttest{
cov <- list(
  binary = c("ECOG", "SMK", "METBRAIN"),
  continuous = c("BMI", "DIAG")
)

cov_all <- list(
  binary = c("SEX", "ECOG", "SMK", "METBRAIN", "METLIVER"),
  continuous = c("BMI", "DIAG", "WEIGHT", "HEIGHT")
)

baseline <- check_matching(
  ipds_wts = pts, agds = AgD_bl,
  summary.list = cov_all, matching.list = cov,
  intervention.arm = TRT,
  comparator = STUDY, comparator.study = "Study XX-1",
  comparator.n = N, comparator.arm = TRT)

baseline
}

}
