% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-DataPreprocessing.R
\name{as.APC.NA.df}
\alias{as.APC.NA.df}
\title{Create NA structure across age, period and cohort groups based on strata}
\usage{
as.APC.NA.df(data, stratify_by, age, period, cohort, include.random = FALSE)
}
\arguments{
\item{data}{Data frame with age, period, cohort, and stratification columns.}

\item{stratify_by}{Stratification variable column. This column
will be used to create the stratum-specific NA structure. It should ideally
be a factor or character vector.}

\item{age}{Age column in \code{data} (must be a numeric/integer column).}

\item{period}{Name of the period column (must be a numeric/integer column).}

\item{cohort}{Name of the cohort column (must be a numeric/integer column).}

\item{include.random}{Logical. Whether to include a unique index ('random')
for each combination of age, period, and stratum, potentially for use as
random effect identifiers in models. \strong{Defaults to FALSE.}}
}
\value{
A data frame containing the original \code{age}, \code{period},
\code{cohort}, and \code{stratify_by} columns, plus:
\itemize{
\item Dummy indicator columns for each level of \code{stratify_by} (e.g., \code{Region_North}, \code{Region_South} if \code{Region} was a stratifying variable).
\item Stratum-specific age, period, and cohort columns (e.g., \code{age_Region_North},
\code{period_Region_North}, \code{cohort_Region_North}), containing the respective
value if the row belongs to that stratum, and \code{NA} otherwise.
\item If \code{include.random = TRUE}, a column named \code{random} with unique integer indices.
The rows are ordered primarily by the stratification variable levels. This is useful for defining random components in MAPC models.
}
}
\description{
Creates a data frame where age, period, and cohort values are placed into
columns specific to their stratum (defined by \code{stratify_var}), with other
strata combinations marked as NA. This structure is often useful for
specific modeling approaches, like certain Age-Period-Cohort (APC) models.
Optionally includes unique indices for random effects.
}
