% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_2d_mass.R
\name{kde_2d}
\alias{kde_2d}
\alias{print.kde_2d}
\alias{plot.kde_2d}
\title{A Two-dimensional Kernel Density Estimate}
\usage{
kde_2d(
  x,
  y = NULL,
  bw = list(x = bw.nrd0, y = bw.nrd0),
  kernel = c("gaussian", "biweight", "cosine", "epanechnikov", "logistic", "optCosine",
    "rectangular", "squaredCosine", "triangular", "tricube", "triweight", "uniform"),
  n = 128,
  x_limits = c(rx[1] - cut * bw["x"], rx[2] + cut * bw["x"]),
  y_limits = c(ry[1] - cut * bw["y"], ry[2] + cut * bw["y"]),
  cut = 1,
  na.rm = FALSE,
  adjust = 53/45,
  ...
)

\method{print}{kde_2d}(x, ...)

\method{plot}{kde_2d}(
  x,
  ...,
  las = 1,
  xlab = bquote(italic(.(x$data_name[["x"]]))),
  ylab = bquote(italic(.(x$data_name[["y"]]))),
  col = hcl.colors(50, "YlOrRd", rev = TRUE)
)
}
\arguments{
\item{x, y}{Numeric vectors of the same length specified in any way acceptable
to \code{\link[grDevices]{xy.coords}}.  In methods, \code{x} will be
an object of class \code{"kde_2d"}}

\item{bw}{bandwidths. May be a numeric vector of length 1 or 2, or a function,
or list of two bandwidth computation functions.  Short entities will
be repeated to length 1.  The first relates to the x-coordinate and
the second to the y.}

\item{kernel}{As for \code{\link{kde_1d}} though 1 or 2 values may be specified
relating to x- and y-coordinates respectively.  Short entities will
be repeated to length 2}

\item{n}{positive integer vector of length 1 or 2 specifying the resolution required
in the x- and y-coordinates respectively.  Short values will be repeated to
length 2.}

\item{x_limits, y_limits}{Numeric vectors specifying the limits required for the result}

\item{cut}{The number of bandwidths beyond the x- and y-range limits for the resuls.}

\item{na.rm}{Should missing values be silently removed?}

\item{adjust}{A factor to adjust both bandwidths to regulate smoothness}

\item{...}{currently ignored, except in method functions}

\item{las, col, xlab, ylab}{base graphics parameters}
}
\value{
A list of results of class \code{"kde_2d"}.  The result may be used directly
        in \code{\link[graphics]{image}} or \code{\link[graphics]{contour}}.
}
\description{
A pure R implementation of an approximate two-dimensional kde computation, where
the approximation depends on the x- and y-resolution being fine, i.e. the number
of both x- and y-points should be reasonably large, at least 256.  The coding
follows the same idea as used in \code{\link[MASS]{kde2d}}, but scales much better
for large data sets.
}
\examples{
krc <- with(Boston, {
  criminality <- log(crim)
  spaciousness <- sqrt(rm)
  kde_2d(criminality, spaciousness, n = 128, kernel = "biweight")
})
plot(krc, xlab = expression(italic(Criminality)), ylab = expression(italic(Spaciousness)))
levs <- hr_levels(krc)
contour(krc, add = TRUE, levels = levs, labels = names(levs))

with(krc, persp(x, 10*y, 3*z, border="transparent", col = "powder blue",
                theta = 30, phi = 15, r = 20, scale = FALSE, shade = TRUE,
                xlab = "Criminality", ylab = "Spaciousness", zlab = "density"))
}
