% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.functions.R
\name{tspline}
\alias{tspline}
\title{Spline time-course functions}
\usage{
tspline(
  type = "bs",
  knots = NULL,
  nknots = 1,
  degree = 1,
  pool.1 = "rel",
  method.1 = "common",
  pool.2 = "rel",
  method.2 = "common",
  pool.3 = "rel",
  method.3 = "common",
  pool.4 = "rel",
  method.4 = "common",
  pool.5 = "rel",
  method.5 = "common",
  pool.6 = "rel",
  method.6 = "common"
)
}
\arguments{
\item{type}{The type of spline. Can take \code{"bs"} (\href{https://mathworld.wolfram.com/B-Spline.html}{B-spline}),
\code{"ns"} (\href{https://mathworld.wolfram.com/CubicSpline.html}{natural cubic spline}) or \code{"ls"} (piecewise linear spline)}

\item{knots}{A numeric vector indicating the location of spline internal knots
(\emph{specified on the same scale as \code{time} in the dataset}). Specifying \code{knots} overrides
\code{nknots}.}

\item{nknots}{The number of spline internal knots. If \code{knots} is not specified then these will by
default be evenly spaced between 0 and the maximum follow-up time in the dataset (\code{max.time}).}

\item{degree}{The degree of the piecewise B-spline polynomial - e.g. \code{degree=1} for linear, \code{degree=2} for quadratic, \code{degree=3} for cubic.}

\item{pool.1}{Pooling for the 1st coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.1}{Method for synthesis of the 1st coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.2}{Pooling for the 2nd coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.2}{Method for synthesis of the 2nd coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.3}{Pooling for the 3rd coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.3}{Method for synthesis of the 3rd coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.4}{Pooling for the 4th coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.4}{Method for synthesis of the 4th coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.5}{Pooling for the 5th coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.5}{Method for synthesis of the 5th coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}

\item{pool.6}{Pooling for the 6th coefficient. Can take \code{"rel"} or \code{"abs"} (see details).}

\item{method.6}{Method for synthesis of the 6th coefficient. Can take \verb{"common}, \code{"random"}, or be assigned a numeric value (see details).}
}
\value{
An object of \code{class("timefun")}
}
\description{
Used to fit B-splines, natural cubic splines, and
piecewise linear splines\insertCite{perperoglu2019}{MBNMAtime}. Note that
B-splines with \code{degree=1} and linear splines are equivalent in fit, but are
parameterised differently which can allow different informative prior specification.
}
\section{Time-course parameters}{

Time-course parameters in the model must be specified using a \code{pool} and a \code{method} prefix.

\code{pool} is used to define the approach used for pooling of a given time-course parameter and
can take any of:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Indicates that \emph{relative} effects should be pooled for this time-course parameter. Relative effects preserve randomisation within included studies, are likely to vary less between studies (only due to effect modification), and allow for testing of consistency between direct and indirect evidence. Pooling follows the general approach for Network Meta-Analysis proposed by \insertCite{lu2004;textual}{MBNMAtime}. \cr
   \code{"abs"} \tab Indicates that study arms should be pooled across the whole network for this time-course parameter  \emph{independently of assigned treatment} to estimate an \emph{absolute} effect. This implies estimating a single value across the network for this time-course parameter, and may therefore be making strong assumptions of similarity. \cr
}


\code{method} is used to define the model used for meta-analysis for a given time-course parameter
and can take any of the following values:\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"common"} \tab Implies that all studies estimate the same true effect (often called a "fixed effect" meta-analysis) \cr
   \code{"random"} \tab Implies that all studies estimate a separate true effect, but that each of these true effects vary randomly around a true mean effect. This approach allows for modelling of between-study heterogeneity. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this time-course parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific time-course parameters (e.g. Hill parameters in Emax functions, power parameters in fractional polynomials) to a single value. \cr
}


When relative effects are modelled on more than one time-course parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
}

\examples{
# Second order B spline with 2 equally spaced knots and random effects on
#the 2nd coefficient
tspline(type="bs", nknots=2, degree=2,
  pool.1="rel", method.1="common",
  pool.2="rel", method.2="random")

# Piecewise linear spline with knots at times of 5 and 10
# Single parameter independent of treatment estimated for 1st coefficient
#with random effects
tspline(type="ls", knots=c(5,10),
  pool.1="abs", method.1="random",
  pool.2="rel", method.2="common")

}
\references{
\insertAllCited
}
