% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_SigmaS.R
\name{get_SigmaS}
\alias{get_SigmaS}
\title{Computes the collection of patterns, means, variances, covariance and correlation
matrices for a given dataset with missing values.}
\usage{
get_SigmaS(X, min_diff = 0)
}
\arguments{
\item{X}{The dataset with incomplete data.}

\item{min_diff}{A natural number such that patterns with \eqn{n_S \leq |S| + min_diff} 
are discarded. Default to zero.}
}
\value{
\code{patterns} The collection of patterns \eqn{\mathbb{S}}.

\code{n_pattern} The cardinality of \eqn{\mathbb{S}}.

\code{data_pattern} A vector where the data are grouped according to \eqn{\mathbb{S}}.

\code{mu_S} The collection of means.

\code{C_S} The collection of covariance matrices.

\code{sigma_squared_S} The collection of variances.

\code{SigmaS} The collection of correlation matrices.

\code{ambient_dimension} The dimension \eqn{d} of the data.
}
\description{
Using the same the notation of  \insertCite{BB2024;textual}{MCARtest}, computes
the collection of patterns \eqn{\mathbb{S}}, means \eqn{\mu_\mathbb{S}}, variances
\eqn{\sigma^2_\mathbb{S}}, covariance matrices \eqn{\Omega_\mathbb{S}}
and correlation matrices \eqn{\Sigma_\mathbb{S}} for a dataset with missing values.
}
\examples{
library(copula)
library(missMethods)
n = 100

cp = claytonCopula(param = c(1), dim = 5)
P = mvdc(copula = cp, margins = c("exp", "exp", "exp", "exp", "exp"),
         paramMargins = list(list(1), list(1), list(1), list(1), list(1)))
X = rMvdc(n, P)
X = delete_MCAR(X, 0.1, c(1,4,5))

get_SigmaS(X)
get_SigmaS(X, min_diff = 20)
}
\references{
\insertRef{BB2024}{MCARtest}
}
