% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.studies.R
\name{run.studies}
\alias{run.studies}
\title{Benchmarking for Multivariate Two-Sample Tests}
\usage{
run.studies(
  Continuous = TRUE,
  study,
  TS,
  TSextra,
  With.p.value = FALSE,
  nsample = 200,
  alpha = 0.05,
  param_alt,
  SuppressMessages = FALSE,
  B = 1000,
  maxProcessor
)
}
\arguments{
\item{Continuous}{=TRUE, run cases for continuous data.}

\item{study}{either the name of the study, or its number in the list. If missing all the studies are run.}

\item{TS}{routine to calculate new test statistics.}

\item{TSextra}{list passed to TS (optional).}

\item{With.p.value}{=FALSE, does user supplied routine return p values?}

\item{nsample}{= 200, desired sample size. 200 is used in included case studies.}

\item{alpha}{=0.05,  type I error probability of tests. 0.05 is used in included case studies.}

\item{param_alt}{(list of) values of parameter under the alternative hypothesis.
If missing included values are used.}

\item{SuppressMessages}{=FALSE, should informative messages be printed?}

\item{B}{= 1000, number of simulation runs.}

\item{maxProcessor}{number of cores to use. If missing the number of physical cores-1
is used. If set to 1 no parallel processing is done.}
}
\value{
A (list of ) matrices of p.values.
}
\description{
This function runs the case studies included in the package.
}
\details{
For details consult vignette(package="MD2sample")
}
\examples{
#The new test is a (included) chi square test:
TSextra=list(which="pval", nbins=rbind(c(3,3), c(4,4)))
run.studies(Continuous=TRUE, study=c("NormalD2", "tD2"), 
          TS=MD2sample::chiTS.cont, TSextra=TSextra, B=100)
}
