% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_electrode_dataset.R
\name{create_electrode_dataset}
\alias{create_electrode_dataset}
\title{Create Electrode Data Set}
\usage{
create_electrode_dataset(data_path, recording_identifier)
}
\arguments{
\item{data_path}{Include path to electrode burst dataset csv or excel file produced by the axis navigator tool. This path should be written within quotation marks and with respect to the current working directory.}

\item{recording_identifier}{Include a unique identifier for the MEA recording being loaded. This identifier will be added to the 'Recording_identifier' column and be used by other MEAanalysis functions to filter the data and calculate burst parameters.}
}
\value{
A reformatted and filtered electrode burst list for use in analysis.
}
\description{
This function reads in, filters, and reformats electrode burst csv files produced by the axis navigator tool
(Axion Biosystems) for use in analysis. This function filters the data to only contain information relating to single electrodes
and burst characteristics. It also adds a 'Recording_identifier' column to enable other MEAanalysis functions to calculate
burst parameters for a specific recording, as well as a column to identify the well a burst was recorded in.
}
\examples{
output_electrode_burst <- create_electrode_dataset(
                                    data_path = system.file("extdata", "input_electrode_burst.csv",
                                                            package = "MEAanalysis"),
                                    recording_identifier = "burst_recording_1")
}
