% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSIS.R
\name{PSIS}
\alias{PSIS}
\title{Ultrahigh-Dimensional Multiclass Linear Discriminant Analysis by Pairwise Sure Independence Screening}
\usage{
PSIS(X, Y, nsis)
}
\arguments{
\item{X}{The design matrix of dimensions n * p. Each row is an observation vector.}

\item{Y}{The response vector of dimension n * 1.}

\item{nsis}{Number of predictors recruited by PSIS. The default is n/log(n).}
}
\value{
the labels of first nsis largest active set of all predictors
}
\description{
A novel pairwise sure independence screening method for linear discriminant analysis with an
ultrahigh-dimensional predictor. This procedure is directly applicable to the situation with many classes.
}
\examples{

n <- 100
p <- 200
rho <- 0.5
data <- GendataLGM(n, p, rho)
data <- cbind(data[[1]], data[[2]])
colnames(data)[1:ncol(data)] <- c(paste0("X", 1:(ncol(data) - 1)), "Y")
data <- as.matrix(data)
X <- data[, 1:(ncol(data) - 1)]
Y <- data[, ncol(data)]
A <- PSIS(X, Y, n / log(n))
A

}
\references{
Pan, R., Wang, H., and Li, R. (2016). Ultrahigh-dimensional multiclass linear discriminant analysis by pairwise sure independence screening. Journal of the American Statistical Association, 111(513):169–179.
}
\author{
Xuewei Cheng \email{xwcheng@hunnu.edu.cn}
}
