% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecFunctions.R
\name{summarize_monospectra}
\alias{summarize_monospectra}
\title{summarize_monospectra}
\usage{
summarize_monospectra(
  processed.obj,
  species,
  directory = NULL,
  minFrequency = 0.5,
  align.tolerance = 5e-04,
  snr = 3,
  halfWindowSize = 20,
  top.N = 50
)
}
\arguments{
\item{processed.obj}{A list from \code{\link{process_monospectra}} which contains peaks information for each strain.}

\item{species}{Species name.}

\item{directory}{Directory. (By default, no summary file will be generated.)}

\item{minFrequency}{Percentage value. A minimum occurrence proportion required for building a reference peaks. All peaks with their occurence proportion less than minFrequency will be moved. (Default: 0.50). See \code{\link[MALDIquant]{filterPeaks}} and \code{\link[MALDIquant]{referencePeaks}} for details.}

\item{align.tolerance}{Mass tolerance. Must be multiplied by 10^-6 for ppm. (Default: 0.0005).}

\item{snr}{Signal-to-noise ratio. (Default: 3).}

\item{halfWindowSize}{The highest peaks in the given window (+/-halfWindowSize) will be recognized as peaks. (Default: 20). See \code{\link[MALDIquant]{detectPeaks}} for details.}

\item{top.N}{The top N peaks will be chosen for the analysis. An integer value. (Default: 50).}
}
\value{
A data frame that contains the peaks informations: m/z, mean log intensity, standard deviation of log intensity, missing rate of peaks. In addition, it also contains species and strain information.
}
\description{
This function summarizes monomicrobial spectra and writes summary in the specified directory.
}
\examples{
spectra.processed.A <- process_monospectra(
   file=system.file("extdata", "listA.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.mono.summary.A <- summarize_monospectra(
   processed.obj=spectra.processed.A, species='A',
   directory=tempdir())
}
