% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msd.comp.R
\name{msd.comp}
\alias{msd.comp}
\title{Compute Model Evaluation Metrics}
\usage{
msd.comp(y, yhat)
}
\arguments{
\item{y}{Numeric vector of observed values.}

\item{yhat}{Numeric vector of predicted values (same length as `y`).}
}
\value{
A named numeric vector with the following components:
\describe{
  \item{r}{Pearson correlation between `y` and `yhat`}
  \item{int}{Intercept of regression of `y` on `yhat`}
  \item{slope}{Slope of regression of `y` on `yhat`}
  \item{r2}{Coefficient of determination (R-squared)}
  \item{bias}{Mean bias: mean(yhat) - mean(y)}
  \item{rmse}{Root mean squared error}
  \item{mse}{Mean squared error}
  \item{sb}{Systematic bias component of MSE}
  \item{nu}{Non-unity slope component of MSE}
  \item{lc}{Lack-of-correlation component of MSE}
  \item{rmse.c}{Corrected RMSE after removing bias}
  \item{mse.c}{Corrected MSE after removing bias}
  \item{rpd}{Ratio of standard deviation to RMSE (RPD)}
  \item{rpiq}{Ratio of interquartile range to RMSE (RPIQ)}
}
}
\description{
This function computes various statistics for comparing observed values `y` with predicted values `yhat`.
It includes correlation, regression coefficients, bias, RMSE, MSE, and predictive performance metrics like RPD and RPIQ.
}
\examples{
\donttest{
y_obs <- c(1.2, 3.4, 2.5, 4.1)
y_pred <- c(1.1, 3.5, 2.4, 4.0)
msd.comp(y_obs, y_pred)
}

}
