#'Method of Moments Estimation of Log-Normal distribution
#'@description function to get the method of moment estimate(s) of log-normal distribution
#'@param data A numeric vector.
#'@param unknown A character string specifying which parameter is (are) unknown to the user.
#'@param meanlog,sdlog	mean and standard deviation of the distribution on the log scale.
#'@param plot logical which controls whether the histogram of the data along with the density curve of the theoretical log normal distribution with the estimated parameters.
#'@param curvecol color of the theoretical density curve
#'@param ... additional plotting parameters
#'@importFrom stats dlnorm var
#'@importFrom graphics hist curve
#'@return the estimated parameters by the method of moments of the data assuming the underlying distribution is log normal distribution
#'@examples
#'lnorm_est(rlnorm(1000),unknown="meanlog",sdlog=1)#meanlog unknown, but sdlog known
#'lnorm_est(rlnorm(1000),unknown="sdlog",meanlog=0)#sdlog unknown, but meanlog known
#'lnorm_est(rlnorm(1000),unknown="both")#both will be estimated
#'@export
lnorm_est=function(data,unknown=c("meanlog","sdlog","both"),meanlog=NULL,sdlog=NULL,plot=TRUE,curvecol="red",...)
{
  avg=mean(data)
  va.r=var(data)
  if(unknown=="meanlog") meanlog=log(avg,exp(1))-((sdlog)^2/2)
  if(unknown=="sdlog") sdlog=sqrt(2*(log(avg,exp(1)))-meanlog)
  if(unknown=="both")
  {
    sdlog= sqrt(log((va.r/avg^2)+1))
    meanlog= log(avg,exp(1))-((sdlog)^2/2)
  }
  if(plot==TRUE)
  {
    hist(data,prob=TRUE,...)
    curve(dlnorm(x,meanlog=meanlog,sdlog=sdlog),add=TRUE,col=curvecol)
  }
  output=list(meanlog,sdlog)
  names(output)=c("meanlog","sdlog")
  return(output)
}
